#pragma once

#include "Common.h"
#include "FloatingBuildingManager.h"



FloatingBuildingManager::FloatingBuildingManager(){

	currentPos = BWAPI::Positions::None;
}

void FloatingBuildingManager::OnFrame(){

	if( currentPos != BWAPI::Positions::None){
	  for(unsigned int i=0; i<Floating.size(); i++){
		  //if damaged, go home
		if( Floating[i]->getHitPoints() != BWAPI::UnitTypes::Terran_Engineering_Bay.maxHitPoints()
			&& Floating[i]->getPosition().getDistance( InfoMan->PosOurBase ) > 2*32 ){
            //Floating[i]->move( InfoMan->PosOurBase );
				sendTo( InfoMan->PosOurBase );
		}
		if(  Floating[i]->getPosition().getDistance( currentPos ) > 2*32  ){
			Floating[i]->move(currentPos);
		}
	  }
	}

}


void FloatingBuildingManager::sendTo( BWAPI::Position to ){
	currentPos = to;
}

void FloatingBuildingManager::addBuilding( Unit* unit ){

	if( unit->getType() == BWAPI::UnitTypes::Terran_Engineering_Bay ){
		unit->lift();
		Floating.push_back( unit );
	}
	

}