#pragma once

#define _USE_MATH_DEFINES
#include <cmath>
#include <math.h>

#include <BWAPI.h>
#include <BWTA.h>

#include <boost/foreach.hpp>

#include "ProductionManager.h"
#include "BaseManager.h"
#include "InformationManager.h"
#include "ScoutManager.h"
#include "WorkerAttackManager.h"
#include "WorkerDefenceManager.h"
#include "BunkerRushManager.h"
#include "GasStealManager.h"
#include "MarineManager.h"
#include "GeneralManager.h"
#include "BioManager.h"
#include "InitialDefenceManager.h"
#include "FloatingBuildingManager.h"
#include "AttackManager.h"
#include "RepairManager.h"
#include "ScannerManager.h"

#include <vector>
#include <string>

enum Strategies{
	Worker_Rush,
	Bunker_Rush,
	Bunker_Rush_Two,
	Gas_Steal,
	BBS,
	One_Fact_3_Rax,
	Normal_Wraith,
	Wall_in,
	Deep_six
};



extern Strategies CurrentStrategy;
extern Strategies InitialStrategy;

typedef std::set<BWAPI::Unit*> UnitSet;

class ProductionManager;
class BuildingManager;
class BaseManager;
class InformationManager;

extern MarineManager* MManager;
extern ProductionManager* ProdMan;
extern BuildingManager* bManager;
extern std::vector<BaseManager*> CCmanager;
extern InformationManager* InfoMan;
extern ScoutManager* ScoutMan;
extern WorkerAttackManager* WAMan;
extern WorkerDefenceManager* WDMan;
extern BunkerRushManager* BRMan;
extern GasStealManager* GasStealMan;
extern GeneralManager* GMan;
extern BioManager* BioMan;
extern InitialDefenceManager* IDMan;
extern FloatingBuildingManager* FBMan;
extern AttackManager* AMan;
extern RepairManager* RPMan;
extern ScannerManager* ScanMan;

//#define M_PI 3.1415926

struct double2
{
	double x,y;

	double2() {}
	double2(double x, double y) : x(x), y(y) {}
	double2(const BWAPI::Position & p) : x(p.x()), y(p.y()) {}

	operator BWAPI::Position()				const { return BWAPI::Position(static_cast<int>(x),static_cast<int>(y)); }

	double2 operator + (const double2 & v)	const { return double2(x+v.x,y+v.y); }
	double2 operator - (const double2 & v)	const { return double2(x-v.x,y-v.y); }
	double2 operator * (double s)			const { return double2(x*s,y*s); }
	double2 operator / (double s)			const { return double2(x/s,y/s); }

	double dot(const double2 & v)			const { return x*v.x + y*v.y; }
	double lenSq()							const { return x*x + y*y; }
	double len()							const { return sqrt(lenSq()); }
	double2 normal()						const { return *this / len(); }

	void normalise() { double s(len()); x/=s; y/=s; } 
	void rotate(double angle) 
	{ 	
		angle = angle*M_PI/180.0;
		*this = double2(x * cos(angle) - y * sin(angle), y * cos(angle) + x * sin(angle));
	}
};