#include "Common.h"
#include "BunkerRushManager.h"
#include "InformationManager.h"


BunkerRushManager::BunkerRushManager(){

	StopBunkerRush = false;

	currentState = Building_Barracks;
	Barracks = NULL;
	Marines.clear();
	Bunkers.clear();

	InfoMan->GetNaturalEnemy();
	for(unsigned int i=0; i<ScoutMan->workerScouts.size(); i++ ){
		AddSCV( ScoutMan->workerScouts[i].scv );
	}
	ScoutMan->workerScouts.clear();//No more need for scouting

	//build a barracks at the natural
	//First find the closest scv
	Unit* closestSCV = NULL;
	int closestD = 999999999;
	BWAPI::Position natPos = BWAPI::Position( InfoMan->EnemyNatural ); 
	for(unsigned int i=0; i<BuildSCVS.size(); i++ ){
		if( BuildSCVS[i]->getDistance(natPos) < closestD  ){
			closestD = BuildSCVS[i]->getDistance(natPos);
			closestSCV = BuildSCVS[i];
		}
	}
	if( closestSCV == NULL ){
		return;//something went wrong, abort
	}
   //Tell the other scvs to move to the natural
	for(unsigned int i=0; i<BuildSCVS.size(); i++ ){
		if( BuildSCVS[i]->getID() != closestSCV->getID()  ){
			BWAPI::Position nextNat = BWAPI::Position( natPos.x()-32 , natPos.y() );
			//BuildSCVS[i]->move(natPos);
			BuildSCVS[i]->move(nextNat);
		}
	}
	//Tell the closest scv to build a barracks
	BuildQueue ProxyRax;
	ProdMan->reservedMinerals +=  BWAPI::UnitTypes::Terran_Barracks.mineralPrice();
	ProxyRax.buildLocation = InfoMan->EnemyNatural;
	bManager->mapArea( bManager->getBuildRectangle(ProxyRax.buildLocation, BWAPI::UnitTypes::Terran_Barracks) , 0,0);
	ProxyRax.type = BWAPI::UnitTypes::Terran_Barracks;
	ProxyRax.scv = closestSCV;
	ProxyRax.building = NULL;
	ProxyRax.Started = false;
	ProdMan->BuildingsQueue.push_back( ProxyRax );

}

void BunkerRushManager::AddSCV( BWAPI::Unit* scv)
{
	BuildSCVS.push_back(scv);
}
BWAPI::Unit* BunkerRushManager::GetBuilder()
{

	if( BuildSCVS.size() > 0 ){
	return BuildSCVS[0];
	}
	return NULL;
}



//First bunker should be put in the main near the choke
BWAPI::TilePosition BunkerRushManager::FirstBunkerLocation()
{
	BWAPI::Position natPos = BWAPI::Position(InfoMan->EnemyNatural);
	BWAPI::Position mainPos = BWAPI::Position(InfoMan->EnemyBase);
	BWTA::Region* natRegion = BWTA::getRegion(natPos);
	BWTA::Region* mainRegion = BWTA::getRegion(mainPos);

	BWTA::Chokepoint* BunkerChoke = NULL;
   BOOST_FOREACH( BWTA::Chokepoint*  choke, BWTA::getChokepoints() ){
	   if( (choke->getRegions().first == natRegion && choke->getRegions().second == mainRegion) ||
		   (choke->getRegions().second == natRegion && choke->getRegions().first == mainRegion) ){
           BunkerChoke = choke;
	   }
   }
   BWAPI::TilePosition TileChoke = BWAPI::TilePosition( BunkerChoke->getCenter() );
   if( CurrentStrategy == Bunker_Rush ){
   TileChoke = bManager->getBuildLocationNear( TileChoke, BWAPI::UnitTypes::Terran_Bunker, mainRegion);
   }
   if( CurrentStrategy == Bunker_Rush_Two ){
   TileChoke = bManager->getBuildLocationNear( TileChoke, BWAPI::UnitTypes::Terran_Bunker, natRegion);
   }

   return TileChoke;
}

//let marines attack and retreat to the bunker
void BunkerRushManager::MarineFrame()
{

	bool ZealotsAttackM = false; //check if a Zealot is attacking a marine

	BOOST_FOREACH( Unit* zealots, Broodwar->enemy()->getUnits() )
    {
		if( zealots->getType() != BWAPI::UnitTypes::Protoss_Zealot ){
			continue;
		}
       for(unsigned int i=0; i<Marines.size(); i++){
		  if( zealots->getTarget() != NULL){
			  if(  zealots->getTarget()->getID() == Marines[i]->getID()  ){
			    ZealotsAttackM = true;
			  }
		  }
		  if( zealots->getOrderTarget() != NULL){
			  if(  zealots->getOrderTarget()->getID() == Marines[i]->getID()  ){
			    ZealotsAttackM = true;
			  }
		  }
	   }
	}

	for(unsigned int i=0; i<Marines.size(); i++){

		std::set<Unit*> EnemyClose = Marines[i]->getUnitsInRadius( 10*32 );
		Unit* closest = NULL;
		Unit* MarineClosest = NULL;
		int closeDist = 9999999;
		int closeDistM = 9999999;
		int EnemyMarines = 0;
		int EnemyDragoons = 0;
		int OurMarines = 0;

		BOOST_FOREACH( Unit* close, EnemyClose )
        {
			//anti Ximp, attack pylon at the natural
			if(  close->getType().isBuilding()  ){
                bool shouldAttack = false;
				if(close->getType() == BWAPI::UnitTypes::Protoss_Pylon 
				 && BWTA::getRegion( close->getPosition() ) == BWTA::getRegion( InfoMan->EnemyNatural ) ){
                  bool shouldAttack = true;
				}
				if(close->getType() == BWAPI::UnitTypes::Protoss_Photon_Cannon
				 && BWTA::getRegion( close->getPosition() ) == BWTA::getRegion( InfoMan->EnemyNatural )
				 && close->isUnpowered() ){
                  bool shouldAttack = true;
				}
				if( shouldAttack == false ){
				  continue;
				}
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDist > Marines[i]->getDistance( close->getPosition() )  ){
				closeDist = Marines[i]->getDistance( close->getPosition() );
				closest = close;
				if( close->getType() == BWAPI::UnitTypes::Terran_Marine ){
					MarineClosest = close;
				}
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDistM > Marines[i]->getDistance( close->getPosition() ) 
				&& close->getType() == BWAPI::UnitTypes::Terran_Marine ){
				closeDistM = Marines[i]->getDistance( close->getPosition() );
				MarineClosest = close;

			}
			if( close->getPlayer() == Broodwar->enemy() && close->getType() == BWAPI::UnitTypes::Terran_Marine ){
				EnemyMarines++;
			}
			if( close->getPlayer() == Broodwar->enemy() && close->getType() == BWAPI::UnitTypes::Protoss_Dragoon ){
				EnemyDragoons++;
			}
		}
		BOOST_FOREACH( Unit* unit, Broodwar->enemy()->getUnits() ){
			if(  unit->getType() ==  BWAPI::UnitTypes::Protoss_Pylon
				  && BWTA::getRegion( unit->getPosition() ) == BWTA::getRegion( InfoMan->EnemyNatural ) ){
				closest = unit;
			}
			if(  unit->getType() ==  BWAPI::UnitTypes::Protoss_Photon_Cannon
				  && BWTA::getRegion( unit->getPosition() ) == BWTA::getRegion( InfoMan->EnemyNatural )
				   && unit->isUnpowered() ){
				closest = unit;
			}
		 }	


		int safeDist = 3*32;
		if( closest != NULL ){
		  if(  Marines[i]->getHitPoints() < 30 && closest->getType() == BWAPI::UnitTypes::Protoss_Zealot ){
          safeDist += 30;
		  }
		}
		if( closest != NULL ){
		 if(  Marines[i]->getHitPoints() < 30 && CurrentStrategy == Bunker_Rush_Two
			 && closest->getType() == BWAPI::UnitTypes::Protoss_Zealot
			 && ZealotsAttackM == true){
          safeDist += 32*3;
		 }
		}

	  // if we can't shoot, run away  if(kite)
	  if ( closeDist < safeDist || EnemyMarines > (Marines.size() - 1) || Marines.size() < EnemyDragoons*4  )
	  {
		  int FleeBunker = -1;
		  if( Bunkers.size() > 0 ){
	        //check for free bunkers
	        for(unsigned int j=0; j<Bunkers.size(); j++){
			  if( Bunkers[j]->getLoadedUnits().size() < 4 ){
			     FleeBunker = j;
		      }
	        }
		  }

		  if(  FleeBunker != -1 ){
			  //prevent spam
			  bool alreadyBunker = false;
			  if( Marines[i]->getOrderTarget() != NULL ){
				  if( Marines[i]->getOrderTarget()->getID() == Bunkers[FleeBunker]->getID()  ){
					  alreadyBunker = true;
				  }
			  }
			  if( alreadyBunker == false ){
			    Marines[i]->rightClick( Bunkers[FleeBunker] );
			  }
			  
		  }

		  if( Bunkers.size() == 0 || FleeBunker == -1 ){
		  //BWAPI::Position fleePosition(Marines[i].marine->getPosition() - closest->getPosition() + Marines[i].marine->getPosition());
		    BWAPI::Position fleePosition( InfoMan->PosOurBase );
        
		    BWAPI::Broodwar->drawLineMap(Marines[i]->getPosition().x(), Marines[i]->getPosition().y(), 
			fleePosition.x(), fleePosition.y(), BWAPI::Colors::Cyan);

		    Marines[i]->move( fleePosition );
		  } 
		  continue;
	  }


		//if there are no enemies nearby, attack;
		if( closest == NULL ||  closeDist > 3*32   ){ //|| closeDist > 3*32
			//if the marine is inside a bunker, unload it
	        for(unsigned int j=0; j<Bunkers.size(); j++){
			  Bunkers[j]->unload(Marines[i]);
	        }
			//if( Marines[i]-> )
			//attack nearest enemy, but prioritse marines
			if( MarineClosest != NULL ){
				closest = MarineClosest;
			}
			if( closest != NULL ){
				if( Marines[i]->getOrderTarget() != NULL ){
				  if( Marines[i]->getOrderTarget() != closest ){
					Marines[i]->attack(  closest );
				  }
				} else {
					Marines[i]->attack(  closest );
				}
			} else if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 
				if( Marines[i]->getPosition().getDistance( attackPos ) > 6*32 ){
			      //BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
		          Marines[i]->attack(  attackPos );
				}
			}
			continue;
		}


	}


}

void BunkerRushManager::OnFrame(){
	
	if( StopBunkerRush ){
		return;
	}

	//remove dead scvs
	for(unsigned int i=0; i<BuildSCVS.size(); i++){
		if( !BuildSCVS[i]->exists() ){
			BuildSCVS.erase( BuildSCVS.begin() + i );
			i--;
			continue;
		}
	}

	//remove dead marines
	for(unsigned int i=0; i<Marines.size(); i++){
		if( !Marines[i]->exists() ){
			Marines.erase( Marines.begin() + i );
			i--;
			continue;
		}
	}

	//remove destroyed bunkers
	for(unsigned int i=0; i<Bunkers.size(); i++){
		if( !Bunkers[i]->exists() ){
			Bunkers.erase( Bunkers.begin() + i );
			i--;
			continue;
		}
	}

	if(  BuildSCVS.size() < 2 ){
		Unit* newSCV = CCmanager[0]->getBuilder();
		if( newSCV != NULL){
			AddSCV( newSCV );
		}
	}

	if( currentState == Building_Barracks && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Barracks ) == 1 ){
		BOOST_FOREACH( Unit* unit, Broodwar->self()->getUnits() ){
			if(  unit->getType() ==  BWAPI::UnitTypes::Terran_Barracks){
				Barracks = unit;
			}
		}
		currentState = First_Bunker;

	  //Tell the closest scv to build a barracks
	  BuildQueue Bunker;
	  ProdMan->reservedMinerals +=  BWAPI::UnitTypes::Terran_Bunker.mineralPrice();
	  Bunker.buildLocation = FirstBunkerLocation();//BWAPI::TilePositions::Unknown;//FirstBunkerLocation();
	  bManager->mapArea( bManager->getBuildRectangle(Bunker.buildLocation, BWAPI::UnitTypes::Terran_Bunker) , 0,0);
	  Bunker.type = BWAPI::UnitTypes::Terran_Bunker;
	  Bunker.scv = GetBuilder();
	  Bunker.building = NULL;
	  Bunker.Started = false;
	  ProdMan->BuildingsQueue.push_back( Bunker );

	}

	if( currentState == First_Bunker && Bunkers.size() > 0 ){
      currentState = Followup_Bunkers;
	}

	MarineFrame();

	//anti-Ximp: let idle scvs attack photon cannons
		for(unsigned int i=0; i<BuildSCVS.size(); i++){
			bool busy = false;
			if( BuildSCVS[i]->getOrder() == BWAPI::Orders::ConstructingBuilding 
				|| BuildSCVS[i]->getOrder() == BWAPI::Orders::Repair){
					continue; //scv already busy
			}
			for(unsigned int j=0; j< ProdMan->BuildingsQueue.size(); j++){
				if( ProdMan->BuildingsQueue[j].scv != NULL ){
				  if( ProdMan->BuildingsQueue[j].scv->getID() == BuildSCVS[i]->getID() ){
					//continue;
					busy = true;
					break;
				  }
				}
			}
			if( busy == true ){
				continue;
			}
			//Unit* photon = NULL;
			Unit* pylo = NULL;
			Unit* probo = NULL;
		  BOOST_FOREACH( Unit* unit, Broodwar->enemy()->getUnits() ){
			  if(  unit->getType() ==  BWAPI::UnitTypes::Protoss_Pylon
				  && BWTA::getRegion( unit->getPosition() ) == BWTA::getRegion( InfoMan->EnemyNatural ) ){
				pylo = unit;
			}
			  if(  unit->getType() ==  BWAPI::UnitTypes::Protoss_Probe
				  && BWTA::getRegion( unit->getPosition() ) == BWTA::getRegion( InfoMan->EnemyNatural )
				  && unit->getPosition().getDistance( BWAPI::Position(InfoMan->EnemyNatural) ) < 32*8 ){
				probo = unit;
			}
		   }	
		  if( probo != NULL ){
			   BuildSCVS[i]->attack( probo );
		  }
		   else if( pylo != NULL ){
			   BuildSCVS[i]->attack( pylo );
		   }
		   //return star scvs
		   if( BuildSCVS[i]->getPosition().getDistance( BWAPI::Position(InfoMan->EnemyNatural) ) < 32*20 ){
			   BuildSCVS[i]->move(  BWAPI::Position(InfoMan->EnemyNatural) );  
		   }
		 }


	if( currentState == Followup_Bunkers ){

		/*
		for(unsigned int i=0; i<Marines.size(); i++){
			for(unsigned int j=0; j<Bunkers.size(); j++){
				if( Bunkers[j]->getLoadedUnits().size() < 4 ){
			      Bunkers[j]->load( Marines[i] );
				  break;
				}
			}
		}
		*/

		//let scvs repair bunkers
		for(unsigned int i=0; i<BuildSCVS.size(); i++){
			if( BuildSCVS[i]->getOrder() == BWAPI::Orders::ConstructingBuilding 
				|| BuildSCVS[i]->getOrder() == BWAPI::Orders::Repair){
					continue; //scv already busy
			}
			for(unsigned int j=0; j<Bunkers.size(); j++){
				if(  Bunkers[j]->getHitPoints() < 350 ){
						BuildSCVS[i]->repair( Bunkers[j] );
						break; //no need for double commands
				}
			}
		 }
		

		if( Bunkers.size()*4 > Marines.size() ){
			Broodwar->drawTextScreen( 60, 60 , " Need more marines to fill bunker " );
		}
		Broodwar->drawTextScreen( 60, 70 , " Marines needed:%d ",Bunkers.size()*4 );
		Broodwar->drawTextScreen( 60, 80 , " Marines currently:%d ", Marines.size() );

		if(  Bunkers.size()*4 > Marines.size() && Broodwar->self()->minerals() > 150 
			&& ProdMan->BuildingsQueue.size() == 0 
			&& Broodwar->self()->supplyUsed() >= Broodwar->self()->supplyTotal() ){

			Broodwar->printf("Adding depot");
	      BuildQueue Depot;
	      ProdMan->reservedMinerals +=  BWAPI::UnitTypes::Terran_Supply_Depot.mineralPrice();
		  Depot.buildLocation = bManager->getBuildLocationNear( Barracks->getTilePosition() , BWAPI::UnitTypes::Terran_Supply_Depot , 0  );//BWAPI::TilePositions::Unknown;
	      bManager->mapArea( bManager->getBuildRectangle(Depot.buildLocation, BWAPI::UnitTypes::Terran_Supply_Depot) , 0,0);
		  Depot.type = BWAPI::UnitTypes::Terran_Supply_Depot;
	      Depot.scv = GetBuilder();
	      Depot.building = NULL;
	      Depot.Started = false;
	      ProdMan->BuildingsQueue.push_back( Depot );

		}

		/*
		//Make sure that only one bunker is not filled yet
		int bunkersNotFilled = 0;
		for( int j=0; j<Bunkers.size(); j++){
		  if( Bunkers[j]->getLoadedUnits().size() < 3 ){
			  bunkersNotFilled++;
		  }
		}
		*/

		unsigned int totBunkers = Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Bunker );


		//&& bunkersNotFilled == 0 
		//&& Marines.size() >= Bunkers.size()*4 - 4
		if( ProdMan->BuildingsQueue.size() == 0 && Broodwar->self()->minerals() > 140 && Marines.size() >= totBunkers*4 - 1 ){// No bunkers currently being build

			//find next bunker location
		    BWAPI::Position mainPos = BWAPI::Position(InfoMan->EnemyBase);
	        BWTA::Region* mainRegion = BWTA::getRegion(mainPos);
			BWAPI::TilePosition NextBunkerTile = Bunkers[ Bunkers.size() - 1 ]->getTilePosition();
			int nextTileX = NextBunkerTile.x();
			int nextTileY = NextBunkerTile.y();
			if(  nextTileX < InfoMan->EnemyBase.x() ){
				nextTileX += 2;
			} else {
				nextTileX -= 2;
			}
			if(  nextTileY < InfoMan->EnemyBase.y() ){
				nextTileY += 2;
			} else {
				nextTileY -= 2;
			}
			NextBunkerTile = BWAPI::TilePosition( nextTileX, nextTileY);
			NextBunkerTile = bManager->getBuildLocationNear(NextBunkerTile, BWAPI::UnitTypes::Terran_Bunker , mainRegion  );
	      //Tell the closest scv to build a bunker
	      BuildQueue Bunker;
	      ProdMan->reservedMinerals +=  BWAPI::UnitTypes::Terran_Bunker.mineralPrice();
		  Bunker.buildLocation = NextBunkerTile;//BWAPI::TilePositions::Unknown;
	      bManager->mapArea( bManager->getBuildRectangle(Bunker.buildLocation, BWAPI::UnitTypes::Terran_Bunker) , 0,0);
	      Bunker.type = BWAPI::UnitTypes::Terran_Bunker;
	      Bunker.scv = GetBuilder();
	      Bunker.building = NULL;
	      Bunker.Started = false;
	      ProdMan->BuildingsQueue.push_back( Bunker );

		}
		

	}//end if state follow up
   
	bool DepotAlive = true;
	if( Broodwar->isVisible(InfoMan->EnemyBase) ){
	  DepotAlive = false; //check if the depot is still in place
	  BOOST_FOREACH( Unit* enemy,  Broodwar->getUnitsOnTile( InfoMan->EnemyBase.x(),InfoMan->EnemyBase.y() ) ){
		  if( enemy->getType().isResourceDepot() ){
			  DepotAlive = true;
		  }
	  }
	}

	//rush succesful, or enemy lifted of command center
	if( DepotAlive == false || Broodwar->getFrameCount() > 15000 ){
		ProdMan->BuildingsQueue.clear();
		CurrentStrategy = Normal_Wraith;//switch to wraits to finish enemy off
		StopBunkerRush = true;
	}

}



void BunkerRushManager::onUnitComplete(BWAPI::Unit *unit){
	
	if( unit->getType() == BWAPI::UnitTypes::Terran_Bunker){
		Bunkers.push_back(unit);
	}
	if( unit->getType() == BWAPI::UnitTypes::Terran_Marine){
		Marines.push_back(unit);
	}

}