#include "BioManager.h"
#include "Common.h"

#include <BWAPI.h>
#include <BWTA.h>
#include <math.h>
#include <algorithm>
#include <boost/foreach.hpp>


BioManager::BioManager()
{
	BioS = Build_up;
	currentBuilding = NULL;
	attackPos = BWAPI::Positions::Unknown;
	allowFB = true;


        BWTA::Region* home  = BWTA::getStartLocation(BWAPI::Broodwar->self())->getRegion();
        std::set<BWTA::Chokepoint*> chokepoints= home->getChokepoints();
		//BWAPI::Position ThisChoke; 
		BWAPI::TilePosition TileChoke;
		int LowestDist = 9999999;

        for(std::set<BWTA::Chokepoint*>::iterator c=chokepoints.begin();c!=chokepoints.end();c++)
        {
			//Broodwar->printf("X:%d",(*c)->getCenter().x());
			BWAPI::Position Current = BWAPI::Position((*c)->getCenter().x(),(*c)->getCenter().y());
			//check if this choke point is closer to the starting location
			if(  Broodwar->self()->getStartLocation().getDistance( TilePosition(Current) ) < LowestDist ){
			  TileChoke = TilePosition(Current);
			  LowestDist = Broodwar->self()->getStartLocation().getDistance( TilePosition(Current) );
			  //toDefend = (*c);
			  chokePos = Current;
			}
			//(*c)->getCenter
        }

}

//find the next building to attack
void BioManager::NextBuilding()
{
  if( currentBuilding == NULL ){

	  attackPos = InfoMan->PosEnemyBase;
	  //Broodwar->enemy()->getUnits();
	  
	  BOOST_FOREACH(  Unit* enemyB, Broodwar->enemy()->getUnits() ){
		  if(  enemyB->getType().isResourceDepot() 
			  &&  enemyB->getPosition().getDistance( InfoMan->PosEnemyBase ) < 100 ){
			  currentBuilding = enemyB;
			  attackPos = enemyB->getPosition();
			  Broodwar->printf("Enemy base set");
		  }
	  }
	  
  } else {
	  if( InfoMan->EnemyBuildings.size() > 0 ){
	    currentBuilding = InfoMan->EnemyBuildings[0].building;
		attackPos = InfoMan->EnemyBuildings[0].position;
		Broodwar->printf("Next building to attack");
	  } else {
		  attackPos = BWAPI::Positions::None;
	  }
  }

}


void BioManager::onBuildingDestroyed(Unit* unit)
{
	if( currentBuilding == NULL ){
		return;
	}

	if(  unit->getID() == currentBuilding->getID()  ){
	  NextBuilding();
	  if( allowFB == true ){
		allowFB = false;
		ProdMan->addToQueue( BWAPI::UnitTypes::Terran_Starport );
	  }
	}

}

void BioManager::Offense(){

	if( currentBuilding == NULL || attackPos == BWAPI::Positions::None ){
		NextBuilding();
	}
	Broodwar->drawCircleMap( attackPos.x() , attackPos.y() ,5,Colors::Purple,true);


	for(unsigned int i=0; i<Marines.size(); i++){
		//Broodwar->printf("%s",Marines[i]->getOrder().c_str() );
		
		std::set<Unit*> EnemyClose = Marines[i]->getUnitsInRadius( 8*32 );
		Unit* closest = NULL;
		int closeDist = 9999999;
		BOOST_FOREACH( Unit* close, EnemyClose )
        {
			if(  close->getType().isBuilding() &&  close->getType() != BWAPI::UnitTypes::Protoss_Photon_Cannon ){
				continue;
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDist > Marines[i]->getDistance( close->getPosition() )  ){
				closeDist = Marines[i]->getDistance( close->getPosition() );
				closest = close;
			}
		}

		//use stim before engaging enemy
		if( closest != NULL && !Marines[i]->isStimmed() && Marines[i]->getHitPoints() == 40 ){
			 Marines[i]->useTech( BWAPI::TechTypes::Stim_Packs );
		}

	  // if we can't shoot, run away  if(kite)
	  if ( ( closeDist < 4*32 &&  Marines[i]->getGroundWeaponCooldown() != 0 ) || Marines[i]->getHitPoints() < 25 )
	  {
		//BWAPI::Position fleePosition(Marines[i].marine->getPosition() - closest->getPosition() + Marines[i].marine->getPosition());
		  BWAPI::Position fleePosition( InfoMan->PosOurBase );
       
		//BWAPI::Broodwar->drawLineMap(Marines[i]->getPosition().x(), Marines[i]->getPosition().y(), 
			//fleePosition.x(), fleePosition.y(), BWAPI::Colors::Cyan);

		Marines[i]->move( fleePosition );
		//Marines[i].state = M_Fleeing;
	  }

		//if there are no enemies nearby, attack;
		if( closest == NULL ||  Marines[i]->getGroundWeaponCooldown() == 0  ){ //|| closeDist > 3*32
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				//BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 

				if( Marines[i]->getPosition().getDistance( attackPos ) > 6*32 ){
			      //Marines[i].state = M_Attacking;
			      //BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
                  if( closest != NULL ){
					  if( Marines[i]->getOrderTarget() == NULL ){
                        Marines[i]->attack(  closest );
					  }
					  else if( Marines[i]->getOrderTarget()->getID() != closest->getID() ){
		                Marines[i]->attack(  closest );
					  }
				  } else {

					  //prevent spam
					  if( Marines[i]->getOrder() != BWAPI::Orders::AttackMove &&
						  Marines[i]->getOrder() != BWAPI::Orders::AttackTile && 
						  Marines[i]->getOrder() != BWAPI::Orders::AttackUnit ){

		                  Marines[i]->attack(  attackPos );

					  }
				  }
				  //Broodwar->printf("Attack");
				}
			}
			continue;
		}


	  
	}


	for(unsigned int i=0; i<Firebats.size(); i++){
		//Broodwar->printf("%s",Marines[i]->getOrder().c_str() );
		
		std::set<Unit*> EnemyClose = Firebats[i]->getUnitsInRadius( 8*32 );
		Unit* closest = NULL;
		int closeDist = 9999999;
		BOOST_FOREACH( Unit* close, EnemyClose )
        {
			if(  close->getType().isBuilding() &&  close->getType() != BWAPI::UnitTypes::Protoss_Photon_Cannon ){
				continue;
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDist > Firebats[i]->getDistance( close->getPosition() )  ){
				closeDist = Firebats[i]->getDistance( close->getPosition() );
				closest = close;
			}
		}

		//use stim before engaging enemy
		if( closest != NULL && !Firebats[i]->isStimmed() && Marines[i]->getHitPoints() == 60
			&& closeDist < 3*32 ){
			 Firebats[i]->useTech( BWAPI::TechTypes::Stim_Packs );
		}

	  // if we can't shoot, run away  if(kite)
	  if ( closest  != NULL && Firebats[i]->getHitPoints() < 25 )
	  {
		//BWAPI::Position fleePosition(Marines[i].marine->getPosition() - closest->getPosition() + Marines[i].marine->getPosition());
		  BWAPI::Position fleePosition( InfoMan->PosOurBase );
       
		BWAPI::Broodwar->drawLineMap(Firebats[i]->getPosition().x(), Firebats[i]->getPosition().y(), 
			fleePosition.x(), fleePosition.y(), BWAPI::Colors::Cyan);

		Firebats[i]->move( fleePosition );
		//Marines[i].state = M_Fleeing;
	  }

		//if there are no enemies nearby, attack;
		if( closest == NULL ||  Marines[i]->getGroundWeaponCooldown() == 0 ){ //|| closeDist > 3*32
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				//BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 

				if( Firebats[i]->getPosition().getDistance( attackPos ) > 6*32 ){
			      //Marines[i].state = M_Attacking;
			      //BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
                  if( closest != NULL ){
					  if( Firebats[i]->getOrderTarget() == NULL ){
                        Firebats[i]->attack(  closest );
					  }
					  else if( Firebats[i]->getOrderTarget()->getID() != closest->getID() ){
		                Firebats[i]->attack(  closest );
					  }
				  } else {
					  //prevent spam
					  if( Firebats[i]->getOrder() != BWAPI::Orders::AttackMove &&
						  Firebats[i]->getOrder() != BWAPI::Orders::AttackTile && 
						  Firebats[i]->getOrder() != BWAPI::Orders::AttackUnit ){
		                  Firebats[i]->attack(  attackPos );
					  }

				  }
				  //Broodwar->printf("Attack");
				}
			}
			continue;
		}
  
	}

	for(unsigned int i=0; i<Medics.size(); i++){
		//Broodwar->printf("%s",Marines[i]->getOrder().c_str() );
		
		std::set<Unit*> UnitsClose = Medics[i]->getUnitsInRadius( 8*32 );
		Unit* closest = NULL;
		int closeDist = 9999999;
		BOOST_FOREACH( Unit* close, UnitsClose )
        {
			if(  close->getType().isBuilding() ){
				continue;
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDist > Medics[i]->getDistance( close->getPosition() )  ){
				closeDist = Medics[i]->getDistance( close->getPosition() );
				closest = close;
			}
		}

	  // if we can't shoot, run away  if(kite)
	  if ( Medics[i]->getHitPoints() < 25 )
	  {
		//BWAPI::Position fleePosition(Marines[i].marine->getPosition() - closest->getPosition() + Marines[i].marine->getPosition());
		  BWAPI::Position fleePosition( InfoMan->PosOurBase );
       
		BWAPI::Broodwar->drawLineMap(Medics[i]->getPosition().x(), Medics[i]->getPosition().y(), 
			fleePosition.x(), fleePosition.y(), BWAPI::Colors::Cyan);

		Medics[i]->move( fleePosition );
		//Marines[i].state = M_Fleeing;
	  }

	  //check if a unit nearby needs healing
	  Unit* needsHeal = NULL;
		BOOST_FOREACH( Unit* close, UnitsClose )
        {
			if(  close->getType().isBuilding() ){
				continue;
			}
			if( close->getPlayer() == Broodwar->self() && closeDist > Medics[i]->getDistance( close->getPosition() )
				&& close->getHitPoints() != close->getType().maxHitPoints()  && !close->isBeingHealed() ){
				needsHeal = close;
			}
		}

		if( needsHeal != NULL ){
			if( Medics[i]->getOrderTarget() == NULL ){
				Medics[i]->useTech( BWAPI::TechTypes::Healing , needsHeal);
		   }
			else if( Medics[i]->getOrderTarget()->getID() != needsHeal->getID() ){
				Medics[i]->useTech( BWAPI::TechTypes::Healing , needsHeal);
		   }
			continue;
		}

		//if there are no enemies nearby, attack;
		if( closest == NULL ){ //|| closeDist > 3*32
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
			  Unit* closestUnit = NULL;
			  int closeDist = 999999;

		      BOOST_FOREACH( Unit* close, Marines )
              {
				  if( close->getPosition().getDistance( InfoMan->PosEnemyBase ) < closeDist ){
			         Unit* closestUnit = close;
			         int closeDist = close->getPosition().getDistance( InfoMan->PosEnemyBase );
				  }
		      }
			  BOOST_FOREACH( Unit* close, Firebats )
              {
				  if( close->getPosition().getDistance( InfoMan->PosEnemyBase ) < closeDist ){
			         Unit* closestUnit = close;
			         int closeDist = close->getPosition().getDistance( InfoMan->PosEnemyBase );
				  }
		      }
			  /*
			  if(  closestUnit != NULL){
				  //Medics[i]->attack(  closestUnit->getPosition() );//heal move
				  Medics[i]->move(  closestUnit->getPosition() );//regular move
			  }
			  */

				//BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 
				if( Medics[i]->getPosition().getDistance( attackPos ) > 6*32 ){
			      Medics[i]->move(  attackPos );//regular move
				}

			}
			/*
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 
				if( Medics[i]->getPosition().getDistance( attackPos ) > 6*32 ){
		            Medics[i]->attack(  attackPos );//heal move
				}
			}
			*/
			continue;
		}
  
	}





	for(unsigned int i=0; i<Tanks.size(); i++){
		//Broodwar->printf("%s",Marines[i]->getOrder().c_str() );
		


		std::set<Unit*> EnemyClose = Tanks[i]->getUnitsInRadius( 10*32 );
		Unit* closest = NULL;
		int closeDist = 9999999;
		BOOST_FOREACH( Unit* close, EnemyClose )
        {
			if(  close->getType().isBuilding() &&  close->getType() != BWAPI::UnitTypes::Protoss_Photon_Cannon ){
				continue;
			}
			if( close->getPlayer() == Broodwar->enemy() && closeDist > Tanks[i]->getDistance( close->getPosition() )  ){
				closeDist = Tanks[i]->getDistance( close->getPosition() );
				closest = close;
			}
		}


		if( closest == NULL ){
		  if( Tanks[i]->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode ){
			Tanks[i]->useTech( BWAPI::TechTypes::Tank_Siege_Mode);
		  }
		} else {
		//unsiege if there are no attacking buildings
        if( closest->getType() != BWAPI::UnitTypes::Zerg_Sunken_Colony &&
			closest->getType() != BWAPI::UnitTypes::Protoss_Photon_Cannon &&
			closest->getType() != BWAPI::UnitTypes::Terran_Bunker ){
		  if( Tanks[i]->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode ){
			Tanks[i]->useTech( BWAPI::TechTypes::Tank_Siege_Mode);
		  }
		}
	  }

	  // if we can't shoot, run away  if(kite)
	  if ( ( closeDist < 5*32 &&  Tanks[i]->getGroundWeaponCooldown() != 0 )  )
	  {
		//BWAPI::Position fleePosition(Marines[i].marine->getPosition() - closest->getPosition() + Marines[i].marine->getPosition());
		  BWAPI::Position fleePosition( InfoMan->PosOurBase );
       
		//BWAPI::Broodwar->drawLineMap(Marines[i]->getPosition().x(), Marines[i]->getPosition().y(), 
			//fleePosition.x(), fleePosition.y(), BWAPI::Colors::Cyan);

		Tanks[i]->move( fleePosition );
		//Marines[i].state = M_Fleeing;
	  }

		//if there are no enemies nearby, attack;
		if( closest == NULL ||  closeDist > 5*32   ){ //|| closeDist > 3*32
			if( InfoMan->EnemyBase != BWAPI::TilePositions::Unknown ){
				//BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase ); 

				if( Tanks[i]->getPosition().getDistance( attackPos ) > 6*32 ){
			      //Marines[i].state = M_Attacking;
			      //BWAPI::Position attackPos = BWAPI::Position( InfoMan->EnemyBase );
                  if( closest != NULL ){

					  //siege up for sunken, bunker and cannon
					  if( closest->getType() == BWAPI::UnitTypes::Zerg_Sunken_Colony ||
						  closest->getType() == BWAPI::UnitTypes::Protoss_Photon_Cannon ||
						  closest->getType() == BWAPI::UnitTypes::Terran_Bunker ){
						if( Tanks[i]->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode ){
			              Tanks[i]->useTech( BWAPI::TechTypes::Tank_Siege_Mode);
		                 }
					  }

					  if( Tanks[i]->getOrderTarget() == NULL ){
                        Tanks[i]->attack(  closest );
					  }
					  else if( Tanks[i]->getOrderTarget()->getID() != closest->getID() ){
		                Tanks[i]->attack(  closest );
					  }
				  } else {
		            Tanks[i]->attack(  attackPos );
				  }
				  //Broodwar->printf("Attack");
				}
			}
			continue;
		}


	  
	}




}

void BioManager::InitialDefence(){



	for(unsigned int i=0; i<Marines.size(); i++){

		if( bManager->WallSound == true ){
		  if( Marines[i]->getPosition().getDistance( InfoMan->PosOurBase ) > 32*6 ){
			Marines[i]->move( InfoMan->PosOurBase );
		  }
		} else {
		  if( Marines[i]->getPosition().getDistance( chokePos ) > 32*6 ){
			Marines[i]->attack( chokePos );
		  }
		}
	  
	}


	for(unsigned int i=0; i<Firebats.size(); i++){

		if( bManager->WallSound == true ){
		  if( Firebats[i]->getPosition().getDistance( InfoMan->PosOurBase ) > 32*6 ){
			Firebats[i]->move( InfoMan->PosOurBase );
		  }
		} else {
		  if( Firebats[i]->getPosition().getDistance( chokePos ) > 32*6 ){
			Firebats[i]->attack( chokePos );
		  }
		}
  
	}

	for(unsigned int i=0; i<Medics.size(); i++){

		if( bManager->WallSound == true ){
		  if( Medics[i]->getPosition().getDistance( InfoMan->PosOurBase ) > 32*6 ){
			Medics[i]->move( InfoMan->PosOurBase );
		  }
		} else {
		  if( Medics[i]->getPosition().getDistance( chokePos ) > 32*6 ){
			Medics[i]->attack( chokePos );
		  }
		}
  
	}
	for(unsigned int i=0; i<Tanks.size(); i++){

		BWAPI::Position toMove = BWAPI::Position( bManager->SupplyWall1.x()*32 + 32, bManager->SupplyWall1.y()*32 + 16 );
		if( bManager->WallSound == false ){
			toMove = chokePos;
		}
		//place tank 3 tiles away
		if( Tanks[i]->getPosition().getDistance( toMove ) > 8*32 ){
			Tanks[i]->move( toMove );
			continue;
		}
		std::set<Unit*> EnemyClose = Tanks[i]->getUnitsInRadius( 10*32 );
		//siege up if in position
		if( (Tanks[i]->getPosition().getDistance( toMove ) <= 8*32 || EnemyClose.size() > 0 )
			&& Tanks[i]->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode ){
			Tanks[i]->stop();
			Tanks[i]->useTech( BWAPI::TechTypes::Tank_Siege_Mode );
			continue;
		}
	}
}

void BioManager::OnFrame()
{
	//return; 

	//remove dead units
	for(unsigned int i=0; i<Marines.size(); i++){
		//remove dead marines
		if( !Marines[i]->exists() ){
			Marines.erase(Marines.begin() + i );
			i--;
			continue;
		}
	}
	for(unsigned int i=0; i<Firebats.size(); i++){
		//remove dead marines
		if( !Firebats[i]->exists() ){
			Firebats.erase(Firebats.begin() + i );
			i--;
			continue;
		}
	}
	for(unsigned int i=0; i<Medics.size(); i++){
		//remove dead marines
		if( !Medics[i]->exists() ){
			Medics.erase(Medics.begin() + i );
			i--;
			continue;
		}
	}
	for(unsigned int i=0; i<Tanks.size(); i++){
		//remove dead marines
		if( !Tanks[i]->exists() ){
			Tanks.erase(Tanks.begin() + i );
			i--;
			continue;
		}
	}


	if( BioS == Build_up  ){
		InitialDefence();
	}

	if( BioS == Push_out  ){
		Offense();
	}



}



//get the next unit to build
BWAPI::UnitType BioManager::nextUnitBO()
{
	//if there is no academy, you can only build marines
	if( ProdMan->Academy == NULL ){
		return BWAPI::UnitTypes::Terran_Marine;
	} else {

		//1 medic for each 1.5 marine or firebat
		if(   Medics.size()*1.5 < Marines.size() + Firebats.size() && ProdMan->getAvailableGas() > 100 ){
			return BWAPI::UnitTypes::Terran_Medic;
		}
		if( ProdMan->getAvailableGas() > 100 && allowFB ){
			return BWAPI::UnitTypes::Terran_Firebat;
		}
		return BWAPI::UnitTypes::Terran_Marine;
	}

}

void BioManager::AddUnit( Unit* unit)
{
	if( unit->getType() == BWAPI::UnitTypes::Terran_Marine ){
		Marines.push_back(  unit );
	}
	if( unit->getType() == BWAPI::UnitTypes::Terran_Firebat ){
		Firebats.push_back(  unit );
	}
	if( unit->getType() == BWAPI::UnitTypes::Terran_Medic ){
		Medics.push_back(  unit );
	}
	if( unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
		|| unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode){
		Tanks.push_back( unit );
	}

}