#include "BaseManager.h"


#include <boost/foreach.hpp>

BaseManager::BaseManager( Unit* CC , BWAPI::TilePosition land ){


	Broodwar->printf("added command center");

	cycleMineral = 0;
	MineralSCV.clear();
	CommandCenter = CC;
	LandLocation = land;

	if( LandLocation == CC->getTilePosition() ){
		BaseReady = true;
	} else {
		BaseReady = false;
	}

	BWAPI::Position landPos = BWAPI::Position( land );

	if( BaseReady == true ){
      for(std::set<Unit*>::iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++)
      {
          if ( CommandCenter->getDistance(*m)<  300 ){
            Minerals.push_back( *m);
		  }
      }
	  for(std::set<Unit*>::iterator g=Broodwar->getGeysers().begin();g!=Broodwar->getGeysers().end();g++)
      {
          if ( CommandCenter->getDistance(*g)<  300 ){
            Geysers.push_back(*g);
			//Broodwar->printf("added geyser");
		  }
      }
	}

    /*
	for(unsigned int i=0; i<InfoMan->Minerals.size(); i++){
		if ( landPos.getDistance( InfoMan->Minerals[i]->getPosition() )<  300 ){
            Minerals.push_back( InfoMan->Minerals[i] );
		  }
	}
	for(unsigned int i=0; i<InfoMan->Geysers.size(); i++){
		if ( landPos.getDistance( InfoMan->Geysers[i]->getPosition() )<  300 ){
			Geysers.push_back( InfoMan->Geysers[i] );
			Broodwar->printf("added geyser");
		  }
	}

	*/
	/*
    for(std::set<Unit*>::iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++)
    {
          if ( CommandCenter->getDistance(*m)<  300 ){
            Minerals.push_back( *m);
		  }
    }
	for(std::set<Unit*>::iterator g=Broodwar->getGeysers().begin();g!=Broodwar->getGeysers().end();g++)
    {
          if ( CommandCenter->getDistance(*g)<  300 ){
            Geysers.push_back(*g);
			Broodwar->printf("added geyser");
		  }
    }
	*/


	//SCVsaturation = Minerals.size() * 2.5; //build in is (almost) saturated at 2.5 times minerals
	SCVsaturation = Minerals.size() * 2 + 2; //force gather trick is almost saturated at 2 times minerals


	//maynarding
	if( BaseReady == true && Broodwar->self()->completedUnitCount( BWAPI::UnitTypes::Terran_Command_Center ) == 2 ){
	  for(int i=0; i<8; i++){
			addSCV( CCmanager[0]->getBuilder() );
	  }
	  //add a refinery
	  ProdMan->addToQueueTile( BWAPI::UnitTypes::Terran_Refinery, Geysers[0]->getTilePosition() );
	}

}


void BaseManager::addSCV( Unit* scv ){

	    /*
	    scv->rightClick( Minerals[cycleMineral] );
		cycleMineral++;
		cycleMineral = cycleMineral % Minerals.size();
		MineralSCV.push_back( scv );
		*/

	    //check if the scv is already assigned
		for(unsigned int i=0; i<MineralSCV.size(); i++){
			if( MineralSCV[i].scv->getID() == scv->getID() ){
				//Broodwar->printf("scv already stored");
				return;
			}
		}

	  SCVmineral newSCV;
	  newSCV.scv = scv;
	  newSCV.mineralPatch = NULL;
	  int minMin = 9999;
      int closMin = -1;
	  for(unsigned int j=0; j<Minerals.size(); j++){
		int curSCV = 0 ;
		for(unsigned int i=0; i<MineralSCV.size(); i++){
			if( MineralSCV[i].mineralPatch == NULL){
				Broodwar->printf("assignment problems mineral scv");
				continue;
			}
			if( MineralSCV[i].mineralPatch->getID() == Minerals[j]->getID() ){
				curSCV++;
			}
		}
		if( curSCV < minMin ){
	      minMin = curSCV;
          closMin = j;
		}
	  }

	  if( closMin != -1 ){
	    newSCV.mineralPatch = Minerals[closMin];
	  }
	  if( newSCV.mineralPatch != NULL  ){
	    newSCV.scv->gather( newSCV.mineralPatch );
	  }
	  if( newSCV.mineralPatch == NULL  ){
		  Broodwar->printf("SCV not assigned to mineral patch");
	  }
	  MineralSCV.push_back( newSCV );
}

void BaseManager::buildSCV(){

	if( BaseReady == false ){
		return;
	}
	if( ProdMan->Academy != NULL && CommandCenter->getAddon() == NULL ){
		return;//build comsat station first
	}

	if( CommandCenter->getTrainingQueue().size() == 0 ){
		CommandCenter->train(BWAPI::UnitTypes::Terran_SCV);
	}

}


void BaseManager::onFrame(){



	if( BaseReady == false){
	  if( LandLocation == CommandCenter->getTilePosition() ){
		BaseReady = true;
		Broodwar->printf("CC has landed");
        for(std::set<Unit*>::iterator m=Broodwar->getMinerals().begin();m!=Broodwar->getMinerals().end();m++)
        {
          if ( CommandCenter->getDistance(*m)<  300 ){
            Minerals.push_back( *m);
		  }
        }
	    for(std::set<Unit*>::iterator g=Broodwar->getGeysers().begin();g!=Broodwar->getGeysers().end();g++)
        {
          if ( CommandCenter->getDistance(*g)<  300 ){
            Geysers.push_back(*g);
			Broodwar->printf("added geyser");
		  }
        }

		//Maynarding
		CCmanager[0]->SCVsaturation -= 18;
		for(int i=0; i<9; i++){
			addSCV( CCmanager[0]->getBuilder() );
		}

		//add a refinery
		ProdMan->addToQueueTile( BWAPI::UnitTypes::Terran_Refinery, Geysers[0]->getTilePosition() );

		/*
		//remove initial defence
		IDMan->stopDefence = true;
		BOOST_FOREACH( Unit* unit, IDMan->DFunits ){
			AMan->AddUnit(unit);
		}
		BOOST_FOREACH( Unit* unit, IDMan->Vultures ){
			AMan->AddUnit(unit);
		}
		IDMan->DFunits.clear();
		IDMan->Vultures.clear();
		*/

		return;
	  }
		if( IDMan->canExpand == true){
			if( !CommandCenter->isLifted() ){
				CommandCenter->lift();
			}

			if( CommandCenter->isLifted() && !Broodwar->isVisible( LandLocation ) ){
				CommandCenter->move( BWAPI::Position( LandLocation ) );
			}
			else if( CommandCenter->isLifted() && CommandCenter->getOrder() != BWAPI::Orders::BuildingLand ){
				CommandCenter->land( LandLocation );
			}
		}
	}

	if( BaseReady == true ){
		//build a comsat station when it is complete
		if( ProdMan->Academy != NULL && CommandCenter->getAddon() == NULL ){
			CommandCenter->buildAddon( BWAPI::UnitTypes::Terran_Comsat_Station );
		}
	}

	for(unsigned int i=0; i<MineralSCV.size(); i++){
		if( !MineralSCV[i].scv->exists() ){//remove destroyed scvs
			MineralSCV.erase( MineralSCV.begin() + i );
			i--;
			continue;
		}
		//check if scv is not used in constructing buildings
		bool alreadyBuilding = false;
		for(unsigned int j=0; j<ProdMan->BuildingsQueue.size(); j++){
			if( ProdMan->BuildingsQueue[j].scv != NULL ){
				if( ProdMan->BuildingsQueue[j].scv->getID() == MineralSCV[i].scv->getID() ){
					alreadyBuilding = true;
			  }
			}
		}
		if( alreadyBuilding ){
			Broodwar->printf("scv already assigned to building");
			MineralSCV.erase( MineralSCV.begin() + i );
			i--;
			continue;
		}

		//no mineral patches avaialbe anymore
		if(  MineralSCV[i].mineralPatch == NULL  ){
			Broodwar->printf("No mineral patch assigned to scv");
          //TODO: give this scv another task
			continue;
		}

		if( !MineralSCV[i].scv->isGatheringMinerals() ){
			MineralSCV[i].scv->gather( MineralSCV[i].mineralPatch );
		}

		//scv currently working at the correct mineral patch
		if(  MineralSCV[i].scv->isCarryingMinerals()   ){
			continue;
		}
		if(  MineralSCV[i].scv->getOrderTarget() == NULL  ){
			MineralSCV[i].scv->gather( MineralSCV[i].mineralPatch );
			continue;
		}

		//scv going to the wrong mineral patch
		if( MineralSCV[i].scv->getOrderTarget()->getID()  !=  MineralSCV[i].mineralPatch->getID()){
			//Broodwar->printf("reassinging scv");
			MineralSCV[i].scv->gather( MineralSCV[i].mineralPatch );
		}
		/*
		//set idle scvs to mine
		if(  !MineralSCV[i].scv->isGatheringMinerals() ){

	      MineralSCV[i]->rightClick( Minerals[cycleMineral] );
		  cycleMineral++;
		  cycleMineral = cycleMineral % Minerals.size();

		}
		*/

	}

	for(unsigned int i=0; i<GasSCV.size(); i++){
		if( !GasSCV[i]->isGatheringGas() && Refinerys.size() > 0  ){
			GasSCV[i]->gather( Refinerys[0] );
		}
	}

}


Unit* BaseManager::getBuilder(){

	Unit* builder = NULL;
	if(  MineralSCV.size() > 0 ){
	  SCVmineral getBuilder = MineralSCV.back();
	  MineralSCV.pop_back();
	  builder = getBuilder.scv;
	  //builder = MineralSCV[0];
	  //MineralSCV.erase( MineralSCV.begin() );
	}
	return builder;
}

//transfer 3 scvs to gas
void BaseManager::toGas(  int ToSend ){
	//int ToSend = 3;
	Broodwar->printf("to gas");
  while( MineralSCV.size() > 0 ){
	  if( Refinerys.size() == 1 ){
		 ToSend--;
		 Unit* gasSCV = getBuilder();
		 if( gasSCV == NULL ){
			 //return;
			 continue;
		 }
	    gasSCV->gather(Refinerys[0]);
	    GasSCV.push_back( gasSCV );
		Broodwar->printf("added 1 to gas");
		if( ToSend == 0 ){
			break;
		}
	  } else {
		  break;
	  }
  }
}