#include "WorkerData.h"

WorkerData::WorkerData(BWAPI::Unit * u) : 
	UnitData(u),
	state(WorkerState::None),
	target(NULL),
	building(NULL),
	now_location(NULL),
	index(0),
	move_to_tp(BWAPI::TilePositions::None),
	build_flag(0)
{
	BOOST_FOREACH(BWAPI::Unit* unit, u->getUnitsInRadius(50)){
		if(!unit->getType().isResourceDepot()) continue;
		depot = unit;
	}
}

WorkerData::~WorkerData(void)
{
}

void WorkerData::update(){
	/*std::ofstream wout("worker.txt", std::ios_base::binary | std::ios_base::out | std::ios_base::trunc);
	if (!wout) {
		std::cout << "***error  o̓t@CJ܂\n";
		exit(1);
	}*/
	unit_update();
	hp = get_unit()->getHitPoints();

	/*if(depot == NULL
		&& !depot->exists()){
			BOOST_FOREACH(BWAPI::Unit* unit, get_unit()->getUnitsInRadius(100)){
				if(!unit->getType().isResourceDepot()) continue;
				depot = unit;
			}
	}*/
	//wout << "start" << std::endl;
	//worker state update
	if(state == WorkerState::None){
		//wout << "n" << std::endl;
		if(get_unit()->getType().isWorker()){
			//wout << "gas" << std::endl;
			/*bool gas_flag = false;
			BOOST_FOREACH(ResourceData &r, resources){
				if(&r == NULL 
					|| r.get_unit() == NULL 
					|| !r.get_refinery() 
					|| !r.get_unit()->isCompleted() 
					|| r.get_assigned_num() >= 3 
					|| BWTA::getRegion(get_position()) != BWTA::getRegion(r.get_position()))
					continue;

				gas_flag = true;
				target = &r;
				r.add_assigned();
				break;
			}
			if(!gas_flag){
				BOOST_FOREACH(ResourceData &r, resources){
					if(&r == NULL 
						|| r.get_unit() == NULL 
						|| !r.get_refinery() 
						|| !r.get_unit()->isCompleted() 
						|| r.get_assigned_num() >= 3 )
						continue;

					gas_flag = true;
					target = &r;
					r.add_assigned();
					break;
				}
			}
			if(gas_flag)
				state = WorkerState::Gas;
			else*/
				state = WorkerState::Mineral;
		}
	}else if(state == WorkerState::Mineral){
		//wout << "m" << std::endl;
		if(depot != NULL 
			//&& (target == NULL ||target->get_assigned_num() >= 2) 
			&& want_num.hatchery > 0
			/*&& playerdata.canMake(BWAPI::UnitTypes::Zerg_Hatchery)*/){

			if(target != NULL ) target->sub_assigned();
			target = NULL;
			state = WorkerState::Build;
			building = BWAPI::UnitTypes::Zerg_Hatchery;
			playerdata.add_build_reserv(building);
			want_num.hatchery--;
		}else if(depot != NULL 
			//&& (target == NULL ||target->get_assigned_num() >= 2)
			//&& HITAData::hatchery_num >= 2 //hatchery
			&& want_num.pool > 0
			&& playerdata.canMake(BWAPI::UnitTypes::Zerg_Spawning_Pool)){
				target = NULL;
				state = WorkerState::Build;
				building = BWAPI::UnitTypes::Zerg_Spawning_Pool;
				playerdata.add_build_reserv(building);
				want_num.pool--;
		}/*else if(depot != NULL 
			//&& (target == NULL ||target->get_assigned_num() >= 2)
			&& want_num.extractor > 0
			&& playerdata.canMake(BWAPI::UnitTypes::Zerg_Extractor)){
				target = NULL;
				state = WorkerState::Build;
				building = BWAPI::UnitTypes::Zerg_Extractor;
				playerdata.add_build_reserv(building);
				want_num.extractor--;
		}*/

		/*if(depot != NULL 
			&& (target == NULL ||target->get_assigned_num() >= 2) 
			&& playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Spawning_Pool.mineralPrice() 
			&& !HITAFlag::zerg_spawning_pool 
			&& !HITAFlag::reserve_zerg_spawning_pool){

			if(target != NULL ) target->sub_assigned();
			target = NULL;
			state = WorkerState::Build;
			get_unit()->stop();
			building = BWAPI::UnitTypes::Zerg_Spawning_Pool;
			playerdata.add_build_reserv(building);
			HITAFlag::reserve_zerg_spawning_pool = true;

		}else if(depot != NULL 
			&& (target == NULL ||target->get_assigned_num() >= 2) 
			&& playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Hatchery.mineralPrice() 
			&& !HITAFlag::reserve_zerg_hatchery){

			if(target != NULL ) target->sub_assigned();
			target = NULL;
			state = WorkerState::Build;
			get_unit()->stop();
			building = BWAPI::UnitTypes::Zerg_Hatchery;
			playerdata.add_build_reserv(building);
			HITAFlag::reserve_zerg_hatchery = true;
		
		}else if(depot != NULL 
			&& (target == NULL || target->get_assigned_num() >= 2) 
			&& playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Evolution_Chamber.mineralPrice()
			&& !HITAFlag::reserve_zerg_evocham 
			&& HITAData::evocham_num < 2 
			&& HITAFlag::zerg_spawning_pool
			&& hatchery_num > 2){

			state = WorkerState::Build;
			get_unit()->stop();
			building = BWAPI::UnitTypes::Zerg_Evolution_Chamber;
			playerdata.add_build_reserv(building);
			HITAFlag::reserve_zerg_evocham = true;

		}else if(depot != NULL 
			&& (target == NULL ||target->get_assigned_num() >= 2) 
			&& playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Queens_Nest.mineralPrice()
			&& playerdata.get_gas() >= BWAPI::UnitTypes::Zerg_Queens_Nest.gasPrice()
			&& !HITAFlag::reserve_zerg_queens_nest
			&& !HITAFlag::zerg_queens_nest
			&& HITAFlag::zerg_lair
			&& HITAFlag::complete_zerg_lair
			&& hatchery_num > 3){

			state = WorkerState::Build;
			get_unit()->stop();
			building = BWAPI::UnitTypes::Zerg_Queens_Nest;
			playerdata.add_build_reserv(building);
			HITAFlag::reserve_zerg_queens_nest = true;

		}else if(depot != NULL 
			&& (target == NULL ||target->get_assigned_num() >= 2) 
			&& playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Extractor.mineralPrice()
			&& !HITAFlag::reserve_zerg_extractor 
			&& HITAFlag::zerg_spawning_pool
			&& hatchery_num > 1){

			bool refinery_flag = false;
			BOOST_FOREACH(ResourceData &r, resources){
				if(r.get_type() == BWAPI::UnitTypes::Resource_Vespene_Geyser && !r.get_refinery()) refinery_flag = true;
			}
			if(refinery_flag){
				state = WorkerState::Build;
				get_unit()->stop();
				building = BWAPI::UnitTypes::Zerg_Extractor;
				playerdata.add_build_reserv(building);
				HITAFlag::reserve_zerg_extractor = true;
			}
		
		

		}else if(target != NULL && target->get_assigned_num() > 1 && !HITAFlag::scout_flag && HITAFlag::enemy_air_weapon){
			target->sub_assigned();
			target = NULL;
			state = WorkerState::Scout;
			HITAFlag::scout_flag = true;
		//}else {

		//}
	}else if(state == WorkerState::Scout){
		//wout << "c" << std::endl;
		bool now_enemybase = false;
		std::pair<BWTA::BaseLocation*, bool> eb;
		BOOST_FOREACH(eb, mapdata.get_enemybases()){
			if(eb.second) continue;
			if(BWTA::getRegion(get_position()) != eb.first->getRegion() || eb.second) continue;
			now_enemybase = true;
			mapdata.set_enemybases_bool(eb.first, true);
			break;
		}
		if(now_enemybase){
			state = WorkerState::Spy;
			HITAFlag::scout_flag = false;
			now_location = eb.first;
			double min_dis = DINF;
			int min_i = 0;
			for(int i=0; i<8; i++){
				BWAPI::Position p = mapdata.get_ebp(now_location,i);
				if(min_dis > get_position().getDistance(p)){
					min_dis = get_position().getDistance(p);
					min_i = i;
				}
			}
			index = min_i;
		}else{
			state = WorkerState::Scout;
		}*/
	}else if(WorkerState::Build){
		//wout << "b" << std::endl;
		if(move_to_tp != BWAPI::TilePositions::None && building != NULL){
			for(int i = move_to_tp.x(); i < move_to_tp.x() + building.tileWidth(); i++){
				for(int j = move_to_tp.y(); j < move_to_tp.y() + building.tileHeight(); j++){
					mapdata.set_buildable_map(i,j,false);
					//BWAPI::Broodwar->drawDotMap(i*TILE_SIZE, j*TILE_SIZE, BWAPI::Colors::Red);
				}
			}
		}
	}
	//wout << "end" << std::endl;
}

void WorkerData::eupdate(){
	unit_update();
	hp = get_unit()->getHitPoints();
}

char * WorkerData::get_state_char(){
	if(state == 0) return "None";
	else if(state == 1) return "Mineral";
	else if(state == 2) return "Gas";
	else if(state == 3) return "Build";
	else if(state == 4) return "Attack";
	else return "????";
}

int WorkerData::get_state() const
{ return state;}

int WorkerData::get_hp() const
{ return hp;}

ResourceData * WorkerData::get_target() const
{ return target;}

BWAPI::UnitType WorkerData::get_building() const
{ return building;}

BWAPI::Unit* WorkerData::get_depot() const
{ return depot;}

BWTA::BaseLocation* WorkerData::get_now_location() const
{ return now_location;}

void WorkerData::set_now_location(BWTA::BaseLocation* b){
	now_location = b;
}

int WorkerData::get_index() const
{ return index;}

void WorkerData::set_target(ResourceData &u){
	target = &u;
}


void WorkerData::set_index(int i){
	index = i;
}

void WorkerData::set_state(const int &i){
	if(i >= WorkerState::Max) return;
	state = i;
	return;
}

void WorkerData::set_move_to_tp(BWAPI::TilePosition tp){
	move_to_tp = tp;
}

BWAPI::TilePosition WorkerData::get_move_to_tp() const
{ return move_to_tp;}

void WorkerData::build(){
	com_num++;
	//if(building.isResourceDepot())
		//BWAPI::Broodwar->drawTextMap(get_position().x(), get_position().y()+20, "build_flag : %d  (%d,%d)  (%d,%d)", build_flag,get_unit()->getTilePosition().x(),get_unit()->getTilePosition().y(),move_to_tp.x(),move_to_tp.y());
	//if(build_flag == 1) return;
	if(get_unit()->getTilePosition().getDistance(move_to_tp) <= 2){
		//if(building.isResourceDepot())
			//BWAPI::Broodwar->drawTextMap(get_position().x(), get_position().y()+ 30,"xxxx");
		build_flag = 1;
		get_unit()->build(get_move_to_tp(), get_building());
		return;
	}
	//if(build_flag == 2) return;
	build_flag = 2;
	BWAPI::Position p(move_to_tp);
	p.x() = move_to_tp.x() * 32 + 16;
	p.y() = move_to_tp.y() * 32 + 16;
	get_unit()->move(p);
	/*if(BWAPI::Broodwar->isExplored(b->getTilePosition().x() - 1, b->getTilePosition().y() - 1)
		&& BWAPI::Broodwar->isExplored(b->getTilePosition().x() + 5, b->getTilePosition().y() - 1)
		&& BWAPI::Broodwar->isExplored(b->getTilePosition().x() - 1, b->getTilePosition().y() + 5)
		&& BWAPI::Broodwar->isExplored(b->getTilePosition().x() + 5, b->getTilePosition().y() + 5)){

	}else{
	}*/
}