#pragma once
#include <BWAPI.h>

class UnitData
{
private:
	BWAPI::Unit* unit;
	BWAPI::Position position;
	int id;
	int size[4];
	BWAPI::UnitType type;
public:
	UnitData();

	UnitData(BWAPI::Unit* u);

	virtual ~UnitData(void);

	void unit_update();

	BWAPI::Position get_position() const;

	const int * get_size() const;

	BWAPI::Unit * get_unit() const;

	BWAPI::UnitType get_type() const;

	int get_id() const;

	bool operator==(const UnitData &right) const;

	bool operator < (const UnitData &right) const;
};

