#include "UnitData.h"

UnitData::UnitData(){}

UnitData::UnitData(BWAPI::Unit* u) :
	unit(u),
	position(u->getPosition()),
	type(u->getType()),
	id(unit->getID())
{
	size[0] = unit->getType().dimensionLeft();
	size[1] = unit->getType().dimensionUp();
	size[2] = unit->getType().dimensionRight();
	size[3] = unit->getType().dimensionDown();
}

UnitData::~UnitData(void){}

void UnitData::unit_update(){
	position = unit->getPosition();
}

BWAPI::Position UnitData::get_position() const
{ return position;}

const int * UnitData::get_size() const
{ return size;}

BWAPI::Unit * UnitData::get_unit() const 
{ return unit;}

BWAPI::UnitType UnitData::get_type() const 
{ return type;}

int UnitData::get_id() const 
{ return id;}

bool UnitData::operator==(const UnitData &right) const { return id == right.get_id();}

bool UnitData::operator < (const UnitData &right) const { return id < right.get_id();}