#include "ResourceData.h"

ResourceData::ResourceData() : 
assigned_num(-1)
{}

ResourceData::~ResourceData(void){}

ResourceData::ResourceData(BWAPI::Unit * u) : 
	UnitData(u),
	remnant(u->getResources()),
	assigned_num(0),
	tposition(u->getTilePosition()),
	refinery(false)
{
	tsize[0] = get_type().tileWidth();
	tsize[1] = get_type().tileHeight();
}

void ResourceData::update(){
	/*std::ofstream rout("resource.txt", std::ios_base::binary | std::ios_base::out | std::ios_base::trunc);
	if (!rout) {
		std::cout << "***error  o̓t@CJ܂\n";
		exit(1);
	}*/
	unit_update();
	remnant = get_unit()->getResources();

	if(get_type() == BWAPI::UnitTypes::Resource_Vespene_Geyser && get_unit()->getType().isRefinery()) refinery = true;
	//rout << mapdata.get_mapwidth() << "," << mapdata.get_mapheight() << std::endl;
	//̎3Tilebuilding֎~
	for(int i = tposition.x() - 3; i < tposition.x() + tsize[0] + 3; i++){
		//rout << "i = " << i << std::endl;
		if(i >= mapdata.get_mapwidth() || i < 0) continue;
		for(int j = tposition.y() - 3; j < tposition.y() + tsize[1] + 3; j++){
			//rout << "j = " << j << std::endl;
			if(j >= mapdata.get_mapheight() || j < 0) continue;
			mapdata.set_buildable_map(i,j,false);
			//BWAPI::Broodwar->drawDotMap(i*TILE_SIZE, j*TILE_SIZE, BWAPI::Colors::Red);
		}
	}
}

int ResourceData::get_remnant() const
{ return remnant;}

int ResourceData::get_assigned_num() const { return assigned_num;}

BWAPI::TilePosition ResourceData::get_tposition() const
{ return tposition;}

bool ResourceData::get_refinery() const
{ return refinery;}

void ResourceData::sub_assigned(){ assigned_num--;}

void ResourceData::add_assigned(){ assigned_num++;}