#include "PlayerData.h"

PlayerData::PlayerData(void) :
	build_mineral(0),
	build_gas(0),
	build_supplytotal(0)
{
}

PlayerData::~PlayerData(void)
{
}

void PlayerData::update(){
	mineral =  BWAPI::Broodwar->self()->minerals();
	gas = BWAPI::Broodwar->self()->gas();
	supplytotal =  BWAPI::Broodwar->self()->supplyTotal();
	supplyused =  BWAPI::Broodwar->self()->supplyUsed();
	//if(logging_flag2) out2 << "111 mineral:" << mineral << " supply:" << supplyused << "/" <<  supplytotal << " ";
	//BWAPI::Broodwar->drawTextScreen(10,200, "build_supply : %d", build_supplytotal);
}

int PlayerData::get_mineral() const
{ return mineral - build_mineral;}

int PlayerData::get_gas() const
{ return gas - build_gas;}

int PlayerData::get_supplytotal() const
{ return supplytotal;}

int PlayerData::get_build_supplytotal() const
{ return build_supplytotal;}

int PlayerData::get_supplyused() const
{ return supplyused;}

void PlayerData::reserv(BWAPI::UnitType type){
	int required = type.supplyRequired();
	if(type == BWAPI::UnitTypes::Zerg_Zergling) required *= 2;
	mineral -= type.mineralPrice();
	gas -= type.gasPrice();
	supplyused += required;
}

void PlayerData::reserv_upgrade(BWAPI::UpgradeType type){
	mineral -= type.mineralPrice();
	gas -= type.gasPrice();
}

void PlayerData::add_build_supplytotal(){
	build_supplytotal += BWAPI::UnitTypes::Zerg_Overlord.supplyProvided();
}

void PlayerData::sub_build_supplytotal(){
	build_supplytotal -= BWAPI::UnitTypes::Zerg_Overlord.supplyProvided();
}

void PlayerData::add_build_reserv(BWAPI::UnitType type){
	build_mineral += type.mineralPrice();
	build_gas += type.gasPrice();
}

void PlayerData::sub_build_reserv(BWAPI::UnitType type){
	build_mineral -= type.mineralPrice();
	build_gas -= type.gasPrice();
}

bool PlayerData::canMake(BWAPI::UnitType type){
	int required = type.supplyRequired();
	if(type == BWAPI::UnitTypes::Zerg_Zergling) required *= 2;
	return (get_mineral() >= type.mineralPrice() && get_gas() >= type.gasPrice() && (get_supplytotal() - get_supplyused() >= required || required == 0));
}                                                                                                                                                     //supply̒l΍(overloadȂȂ)

bool PlayerData::orderDrone(){
	return !(want_num.hatchery  > 0 
		  || want_num.overload  > 0
		  || want_num.pool      > 0 //&& HITAData::hatchery_num >= 2
		  ||(want_num.zergling  > 0 && HITAData::pool_num > 0)
		  /*|| want_num.extractor > 0*/);
}