#include "OtherUnitData.h"

//Overload̂߂̃NXɂȂ肻
OtherUnitData::OtherUnitData(BWAPI::Unit * u) : 
	UnitData(u),
	state(OtherUnitState::None),
	now_location(NULL)
{
}

OtherUnitData::OtherUnitData(void){}

OtherUnitData::~OtherUnitData(void){}

void OtherUnitData::update(){
	unit_update();
	hp = get_unit()->getHitPoints();

	if(state == OtherUnitState::None){
		if(get_unit()->getType() == BWAPI::UnitTypes::Zerg_Overlord)
		{
			state = OtherUnitState::AllScout;
		}

	}else if(state == OtherUnitState::AllScout){
		if(attackers.empty()){
			bool now_enemybase = false;
			std::pair<BWTA::BaseLocation*, bool> eb;
			BOOST_FOREACH(eb, mapdata.get_enemybases()){
				if(eb.second) continue;
				if(BWTA::getRegion(get_position()) != eb.first->getRegion() || eb.second) continue;
				now_enemybase = true;
				mapdata.set_enemybases_bool(eb.first, true);
				break;
			}
			if(now_enemybase){
				state = OtherUnitState::Spy;
				now_location = eb.first;
			}
		}else{
			state = OtherUnitState::AirScout;
		}

	}else if(state == OtherUnitState::Spy){
		if(HITAFlag::enemy_air_weapon){
			state = OtherUnitState::AllScout;
		}

	}else if(state == OtherUnitState::AirScout){
		bool now_enemybase = false;
		std::pair<BWTA::BaseLocation*, bool> eb;
		BOOST_FOREACH(eb, mapdata.get_enemybases()){
			if(eb.second) continue;
			if(BWTA::getRegion(get_position()) != eb.first->getRegion() || eb.second) continue;
			now_enemybase = true;
			mapdata.set_enemybases_bool(eb.first, true);
			break;
		}
		if(now_enemybase){
			state = OtherUnitState::Spy;
			now_location = eb.first;
		}
	}
}

void OtherUnitData::eupdate(){
	unit_update();
	hp = get_unit()->getHitPoints();
}

char * OtherUnitData::get_state_char() const
{
	if(state == 0) return "None";
	else if(state == 1) return "AllScout";
	else if(state == 2) return "AirScout";
	else if(state == 3) return "Spy";
	else return "????";
}

int OtherUnitData::get_state() const
{ return state;}

int OtherUnitData::get_hp()const
{ return hp;}

BWTA::BaseLocation* OtherUnitData::get_now_location() const
{ return now_location;}

void OtherUnitData::set_now_location(BWTA::BaseLocation* b){
	now_location = b;
}

void OtherUnitData::set_state(const int &i){
	if(i >= OtherUnitState::Max) return;
	state = i;
	return;
}