#pragma once
#include <BWAPI.h>
#include <BWTA.h>
#include <map>
#include <vector>
#include <algorithm>
#include <boost/foreach.hpp>
#include <deque>
#include "Const.h"

class MapData
{

private:
	//std::map<std::vector<int>, BWTA::BaseLocation*> gbaseframe; //BaseƂŌɌframe
	//std::map<std::vector<int>, BWTA::BaseLocation*> abaseframe; //łȂBaseƂŌɌframe

	std::deque<BWTA::BaseLocation*> ground_base;
	std::deque<BWTA::BaseLocation*> air_base;
	std::deque<BWTA::BaseLocation*> all_base;
	std::map<int, BWTA::BaseLocation*> next_mybase; //Basëʒu
	std::map<BWTA::BaseLocation*, bool> enemybases; //GBaseƂɍSpy邩ǂ
	std::map<BWTA::BaseLocation*, std::vector<BWAPI::Position> > enemybases_position; //GBaseƂ̏ꏊ8̒[
	std::map<int, BWTA::BaseLocation*> enemybases_distance; //GBaseƋ
	std::map<BWTA::BaseLocation*, int> mybases; //BaseƂ̐Y
	int mapwidth;
	int mapheight;
	std::vector<std::vector<bool>> buildable_map; //MapTilePositionŋ؂ABuildingu邩
	int mybase_num; //Base̐(workerBuildɂȂuԂ+)

public:

	MapData(void);

	~MapData(void);

	void mapdata_init();

	void update();

	//gbaseframe

	BWTA::BaseLocation* get_next_scoutgp();


	//abaseframe

	BWTA::BaseLocation* get_next_scoutap();

	//allbase

	BWTA::BaseLocation* get_next_scoutp();


	//mybase
	void set_mybases(const BWTA::Region *r);

	std::map<BWTA::BaseLocation*, int> get_mybases() const;

	int get_mybase_state(BWTA::BaseLocation* b);

	void erase_mybases(BWAPI::Position p);



	//enemybases & enemybases_position
	void set_enemybases(const BWTA::Region *r);

	void set_enemybases_bool(BWTA::BaseLocation* b, bool flag);

	std::map<BWTA::BaseLocation*, bool> get_enemybases() const;

	void erase_enemybases(BWAPI::Position p);

	BWTA::BaseLocation* get_near_enemybase();

	BWAPI::Position MapData::get_ebp(BWTA::BaseLocation* b, int i) const;

	std::map<BWTA::BaseLocation*, std::vector<BWAPI::Position> > get_enemybases_position() const;


	//buildable_map
	void set_buildable_map(int x, int y, bool flag);

	std::vector<std::vector<bool>> get_buildable_map() const;


	//mapwdth & mapheight
	int get_mapwidth() const;

	int get_mapheight() const;


	//next_mybase & mybase_num
	BWTA::BaseLocation* get_next_mybase();

	void set_next_mybase(BWTA::BaseLocation* b);

	int get_mybase_num() const;

	void add_mybase_num();

	void sub_mybase_num();
};

