#include "LarvaData.h"

LarvaData::LarvaData(BWAPI::Unit* u):
	UnitData(u),
	buildtype(BWAPI::UnitTypes::None),
	is_morphing(false),
	morph_frame(BWAPI::Broodwar->getFrameCount())
{
	mybase = BWTA::getNearestBaseLocation(get_position());
}

LarvaData::LarvaData(void)
{
}

LarvaData::~LarvaData(void)
{
}

void LarvaData::update(){
	unit_update();
}

void LarvaData::set_buildtype(BWAPI::UnitType type){
	buildtype = type;
}

BWAPI::UnitType LarvaData::get_buildtype() const
{ return buildtype;}

BWTA::BaseLocation* LarvaData::get_mybase() const
{ return mybase;}

void LarvaData::morph() const{
	if(logging_flag2) out2 << "->" << buildtype.c_str() << " ";
	get_unit()->morph(buildtype);
	com_num++;
}

bool LarvaData::isMorphing() const
{ return is_morphing;}

void LarvaData::setIsMorphing(bool m){
	is_morphing = m;
}

int LarvaData::getMorphFrame() const
{ return morph_frame;}

void LarvaData::setMorphFrame(int frame){
	morph_frame = frame;
}