#include "HITAModule.h"


void HITAModule::onStart()
{
	BWAPI::Broodwar->setLocalSpeed(0);
	BWAPI::Broodwar->enableFlag(BWAPI::Flag::UserInput);
	BWTA::readMap();
	BWTA::analyze();
	if(logging_flag2){
		out2.open("test2.txt", std::ios_base::binary | std::ios_base::out | std::ios_base::trunc);
		assert(out2);
	}
	mapdata.mapdata_init();
}

void HITAModule::onFrame(){
	if(logging_flag2){
		out2 << BWAPI::Broodwar->getFrameCount() << " ";
		out2 << "m:" << BWAPI::Broodwar->self()->minerals() << " s:" << BWAPI::Broodwar->self()->supplyUsed() << "/" <<  BWAPI::Broodwar->self()->supplyTotal() << " ";
		int drone = 0,
			larva = 0,
			egg = 0,
			overload = 0,
			zergling = 0,
			hatchery = 0,
			pool = 0;
		BOOST_FOREACH(BWAPI::Unit* unit, BWAPI::Broodwar->self()->getUnits()){
			BWAPI::UnitType type = unit->getType();
			if(type == BWAPI::UnitTypes::Zerg_Drone) drone++;
			else if(type == BWAPI::UnitTypes::Zerg_Larva) larva++;
			else if(type == BWAPI::UnitTypes::Zerg_Egg){
				out2 << "[" << unit->getBuildType().c_str() << "]";
				egg++;
			}else if(type == BWAPI::UnitTypes::Zerg_Overlord) overload++;
			else if(type == BWAPI::UnitTypes::Zerg_Zergling) zergling++;
			else if(type == BWAPI::UnitTypes::Zerg_Hatchery) hatchery++;
			else if(type == BWAPI::UnitTypes::Zerg_Spawning_Pool) pool++;
		}
		out2 << "d:" << drone << " ";
		out2 << "l:" << larva << " ";
		out2 << "e:" << egg << " ";
		out2 << "o:" << overload << " ";
		out2 << "z:" << zergling << " ";
		out2 << "h:" << hatchery << " ";
		out2 << "p:" << pool << " ";
	}

	com_num = 0;
	clock_t start_time, end_time, all_start_time, all_end_time;
	double exe_time, all_exe_time;
	all_start_time = clock();

	start_time = clock();
	if(logging_flag){
		out.open("test.txt", std::ios_base::binary | std::ios_base::out | std::ios_base::trunc);
		assert(out);
	}

	/*if (!out) {
		BWAPI::Broodwar->drawTextScreen(200,200, "***error  o̓t@CJ܂\n");
		//exit(1);
	}*/
	//out << BWAPI::Broodwar->getFrameCount() << std::endl;

	
	if(logging_flag) out << "1,"<< std::endl;
	playerdata.update(); //~lȂǂ̍XV
	//reservebuildings.update();
	if(logging_flag) out << "2,"<< std::endl;
	mapdata.update(); //}bv̍XV

	end_time = clock();
	exe_time = end_time - start_time;
	max_init = std::max(exe_time, max_init);
	BWAPI::Broodwar->drawTextScreen(430,130, "InitUpdate");
	BWAPI::Broodwar->drawTextScreen(550,130, "%f", max_init);

	//Rjbg̍폜@񂾂Aω//////////////////////////////////////////////////////////////
	////worker
	start_time = clock();
	if(logging_flag) out << "3-1,"<< std::endl;
	std::vector<WorkerData> erase_workers;
	for(std::set<WorkerData>::iterator w = workers.begin(); w != workers.end(); w++){
		if((*w).get_unit() == NULL || !(*w).get_unit()->exists() || (*w).get_type() != (*w).get_unit()->getType()){
			erase_workers.push_back(*w);
			pre_id.erase((*w).get_id());
		}
	}
	BOOST_FOREACH(WorkerData w, erase_workers){
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Spawning_Pool) HITAFlag::reserve_zerg_spawning_pool = false; //spawning pool郆jbg͂Ȃ
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Queens_Nest) HITAFlag::reserve_zerg_queens_nest = false;
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Extractor) HITAFlag::reserve_zerg_extractor = false;
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Evolution_Chamber) HITAFlag::reserve_zerg_evocham = false;
		if(w.get_target() != NULL) w.get_target()->sub_assigned(); //~l̊蓖Đ
		if(w.get_state() == WorkerState::Build) playerdata.sub_build_reserv(w.get_building()); //\񂵂Ăɖ߂
		if(w.get_state() == WorkerState::Build && w.get_building() == BWAPI::UnitTypes::Zerg_Hatchery){
			HITAFlag::reserve_zerg_hatchery = false;
			if(HITAFlag::next_mybase_flag){ //̊nɍsĂjbgȂ
				HITAFlag::next_mybase_flag = false;
				bool flag = false;
				BOOST_FOREACH(BWAPI::Unit* u, BWAPI::Broodwar->getUnitsOnTile(temp_next_mybase->getTilePosition().x(), temp_next_mybase->getTilePosition().y())){
					if(u->getType() == BWAPI::UnitTypes::Zerg_Hatchery){
						flag = true;
						break;
					}
				}
				if(!flag){  //ɍshatchery݂ȂȂ
					mapdata.set_next_mybase(temp_next_mybase); //nɖ߂
					mapdata.sub_mybase_num(); //my_base̐炷(sđ₵Ă)
				}
			}
		}
		workers.erase(w);
	}
	erase_workers.clear();

	if(logging_flag) out << "3-2,"<< std::endl;
	////attacker
	std::vector<AttackerData> erase_attackers;
	for(std::set<AttackerData>::iterator a = attackers.begin(); a != attackers.end(); a++){
		if((*a).get_unit() == NULL || !(*a).get_unit()->exists() || (*a).get_type() != (*a).get_unit()->getType()){
			erase_attackers.push_back(*a);
			pre_id.erase((*a).get_id());
		}
	}
	BOOST_FOREACH(AttackerData a, erase_attackers){
		if(a.get_state() == AttackerState::Scout) HITAFlag::scout_flag = false;
		attackers.erase(a);
	}
	erase_attackers.clear();

	if(logging_flag) out << "3-3,"<< std::endl;
	////building
	std::vector<BuildingData> erase_buildings;
	for(std::set<BuildingData>::iterator b = buildings.begin(); b != buildings.end(); b++){
		if((*b).get_unit() == NULL || !(*b).get_unit()->exists() || (*b).get_type() != (*b).get_unit()->getType()){
			erase_buildings.push_back(*b);
			pre_id.erase((*b).get_id());
		}
	}
	BOOST_FOREACH(BuildingData &b, erase_buildings){
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Spawning_Pool){
			HITAFlag::zerg_spawning_pool = false; //spawning poolȂȂ
			HITAFlag::complete_zerg_spawning_pool = false;
		}
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Queens_Nest){
			HITAFlag::zerg_queens_nest = false;
			HITAFlag::complete_zerg_queen_nest = false;
		}
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Lair){
			HITAFlag::complete_zerg_lair = false;
			HITAFlag::zerg_lair = false;
		}
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Hive){
			HITAFlag::complete_zerg_lair = false;
			HITAFlag::complete_zerg_hive = false;
			HITAFlag::zerg_lair = false;
			HITAFlag::zerg_hive = false;
		}
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Evolution_Chamber) HITAData::evocham_num--;
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Hatchery){
			//hatchery_num--;
			mapdata.erase_mybases(b.get_position()); //erase̕Kv邩͌Ŋm߂Ă
		}
		buildings.erase(b);
	}
	erase_buildings.clear();

	if(logging_flag) out << "3-4,"<< std::endl;
	////resource
	std::vector<ResourceData> erase_resources;
	for(std::set<ResourceData>::iterator r = resources.begin(); r != resources.end(); r++){
		if((*r).get_unit() == NULL || (*r).get_remnant() <= 0){
			erase_resources.push_back(*r);
			pre_id.erase((*r).get_id());
		}
	}
	BOOST_FOREACH(ResourceData r, erase_resources){
		BOOST_FOREACH(WorkerData &w, workers){
			if(w.get_target() != NULL && w.get_target()->get_id() == r.get_id()){
				w.set_target(ResourceData());
				w.get_unit()->stop();
			}
		}
		resources.erase(r);
	}
	erase_resources.clear();

	if(logging_flag) out << "3-5,"<< std::endl;
	////larva
	std::vector<LarvaData> erase_larvas;
	for(std::set<LarvaData>::iterator l = larvas.begin(); l != larvas.end(); l++){
		if((*l).get_unit() == NULL || !(*l).get_unit()->exists() ||( (*l).get_unit()->getType() != BWAPI::UnitTypes::Zerg_Larva /*&& (*l).get_unit()->getType() != BWAPI::UnitTypes::Zerg_Egg*/)){ //larvaegg͊܂܂Ȃ(\܂߂ĐmworkerȂǂ̐m邽)
			erase_larvas.push_back(*l);
			pre_id.erase((*l).get_id());
		}
	}
	BOOST_FOREACH(LarvaData l, erase_larvas){
		larvas.erase(l);
	}
	erase_larvas.clear();

	if(logging_flag) out << "3-6,"<< std::endl;
	////other
	std::vector<OtherUnitData> erase_others;
	for(std::set<OtherUnitData>::iterator o = others.begin(); o != others.end(); o++){
		if((*o).get_unit() == NULL || !(*o).get_unit()->exists() || (*o).get_type() != (*o).get_unit()->getType()){
			erase_others.push_back(*o);
			pre_id.erase((*o).get_id());
		}
	}
	BOOST_FOREACH(OtherUnitData o, erase_others){
		if(o.get_state() == OtherUnitState::Spy) mapdata.set_enemybases_bool(o.get_now_location(), false);
		//if(o.get_type() == BWAPI::UnitTypes::Zerg_Egg) playerdata.sub_build_supplytotal();
		others.erase(o);
	}
	erase_others.clear();


	//Gjbg̍폜//////////////////////////////////////////////////////////////
	////worker
	if(logging_flag) out << "4-1,"<< std::endl;
	for(std::set<WorkerData>::iterator w = eworkers.begin(); w != eworkers.end(); w++){
		if((*w).get_unit() == NULL || (!(*w).get_unit()->exists() || (*w).get_type() != (*w).get_unit()->getType()) && (*w).get_unit()->isVisible()){
			erase_workers.push_back(*w);
			epre_id.erase((*w).get_id());
		}
	}
	BOOST_FOREACH(WorkerData w, erase_workers){
		eworkers.erase(w);
	}
	erase_workers.clear();

	////attacker
	if(logging_flag) out << "4-2,"<< std::endl;
	for(std::set<AttackerData>::iterator a = eattackers.begin(); a != eattackers.end(); a++){
		if((*a).get_unit() == NULL || (!(*a).get_unit()->exists() || (*a).get_type() != (*a).get_unit()->getType()) && (*a).get_unit()->isVisible()){
			erase_attackers.push_back(*a);
			epre_id.erase((*a).get_id());
		}
	}
	BOOST_FOREACH(AttackerData a, erase_attackers){
		eattackers.erase(a);
	}
	erase_attackers.clear();

	////building
	if(logging_flag) out << "4-3" << std::endl;
	for(std::set<BuildingData>::iterator b = ebuildings.begin(); b != ebuildings.end(); b++){
		if((*b).get_unit() == NULL || (!(*b).get_unit()->exists() || (*b).get_type() != (*b).get_unit()->getType()) && (*b).get_unit()->isVisible()){
			erase_buildings.push_back(*b);
			epre_id.erase((*b).get_id());
		}
	}
	if(logging_flag) out << "check"<< std::endl;
	if(!erase_buildings.empty()){
	BOOST_FOREACH(BuildingData &b, erase_buildings){
		if(logging_flag) out << "1"<< std::endl;
		if(logging_flag) out << &b << std::endl;
		if(logging_flag) out << b.get_type().c_str() << std::endl;
		if(logging_flag) out << BWAPI::Broodwar->enemy()->getRace().getCenter().c_str() << std::endl;
		if(logging_flag) out << b.get_position() << std::endl;
		if(b.get_type() == BWAPI::Broodwar->enemy()->getRace().getCenter()
			&& b.get_position() != NULL
			&& b.get_position() != BWAPI::Positions::None
			&& b.get_position() != BWAPI::Positions::Unknown
			&& b.get_position() != BWAPI::Positions::Invalid) mapdata.erase_enemybases(b.get_position());
		if(logging_flag) out << "2"<< std::endl;
		ebuildings.erase(b);
	}
	}
	erase_buildings.clear();

	////other
	if(logging_flag) out << "4-4,"<< std::endl;
	for(std::set<OtherUnitData>::iterator o = eothers.begin(); o != eothers.end(); o++){
		if((*o).get_unit() == NULL || (!(*o).get_unit()->exists() || (*o).get_type() != (*o).get_unit()->getType()) && (*o).get_unit()->isVisible()){
			erase_others.push_back(*o);
			epre_id.erase((*o).get_id());
		}
	}
	BOOST_FOREACH(OtherUnitData o, erase_others){
		eothers.erase(o);
	}
	erase_others.clear();


	end_time = clock();
	exe_time = end_time - start_time;
	max_erase = std::max(exe_time, max_erase);
	BWAPI::Broodwar->drawTextScreen(430,140, "Erase");
	BWAPI::Broodwar->drawTextScreen(550,140, "%f", max_erase);

	//Rjbg̒ǉ/////////////////////////////////////////////////////////////////////////////////
	start_time = clock();

	if(logging_flag) out << "5,"<< std::endl;
	BOOST_FOREACH(BWAPI::Unit * u, BWAPI::Broodwar->self()->getUnits()){
		if( ! u->exists() ) continue;
		if( pre_id.find(u->getID()) != pre_id.end() )  continue;
		BWAPI::UnitType type = (u->getType() == BWAPI::UnitTypes::Zerg_Egg) ? u->getBuildType() : u->getType(); //Egg@܂́@jbg@ǂ炩
		//if(type == BWAPI::UnitTypes::Zerg_Egg) continue;
		//BWAPI::UnitType type = u->getType();
		pre_id.insert(u->getID());
		if(type.isWorker()){
			workers.insert(WorkerData(u));
		}else if(type == BWAPI::UnitTypes::Zerg_Larva){
			larvas.insert(LarvaData(u));
		}else if(type == BWAPI::UnitTypes::Zerg_Overlord){
			/*if(u->getType() == BWAPI::UnitTypes::Zerg_Overlord){
				if(!HITAFlag::init_overload) playerdata.sub_build_supplytotal(); //sĂsupplytotal炷
				else HITAFlag::init_overload = false; //ŏoverload͗O
			}*/
			others.insert(OtherUnitData(u));
		}else if(type.isRefinery()){
			resources.insert(ResourceData(u));
		}else if(type.isBuilding()){
			buildings.insert(BuildingData(u));
			if(type == BWAPI::UnitTypes::Zerg_Evolution_Chamber) HITAData::evocham_num++;
			/*if(type.isResourceDepot()){
				mapdata.set_mybases(BWTA::getRegion(u->getPosition())); //hatcheryȂΐVnȂ
				//hatchery_num++;
				if(HITAFlag::next_mybase_flag) HITAFlag::next_mybase_flag = false;
			}*/
		}else{
			attackers.insert(AttackerData(u));
		}
	}

	{ //n̎Resourceǉ
	if(logging_flag) out << "6,"<< std::endl;
	std::pair<BWTA::BaseLocation*, int> mb;
	BOOST_FOREACH(mb, mapdata.get_mybases()){
		BOOST_FOREACH(BWAPI::Unit * u, mb.first->getMinerals()){
			if(u->getResources() <= 0 || pre_id.find(u->getID()) != pre_id.end())  continue;
			pre_id.insert(u->getID());
			resources.insert(ResourceData(u));
		}
		BOOST_FOREACH(BWAPI::Unit * u, mb.first->getGeysers()){
			if( pre_id.find(u->getID()) != pre_id.end() )  continue;
			pre_id.insert(u->getID());
			resources.insert(ResourceData(u));
		}
	}
	}


	//unit̐𐔂
	HITAData::drone_num = workers.size();
	HITAData::overload_num = others.size();
	HITAData::hatchery_num = 0;
	HITAData::base_num = mapdata.get_mybase_num();
	HITAData::pool_num = 0;
	HITAData::zergling_num = 0;
	HITAData::extractor_num = 0;


	////zergling̐
	BOOST_FOREACH(AttackerData &a, attackers){
		if(a.get_type() == BWAPI::UnitTypes::Zerg_Zergling) HITAData::zergling_num++; 
		else if(a.get_type() == BWAPI::UnitTypes::Zerg_Egg/*a.get_unit()->getBuildType() == BWAPI::UnitTypes::Zerg_Zergling*/) HITAData::zergling_num += 2;
	}

	////ωwߒunit̐
	BOOST_FOREACH(LarvaData &l, larvas){
		if(!l.isMorphing()) continue;
		if(l.get_buildtype() == BWAPI::UnitTypes::Zerg_Drone) HITAData::drone_num++;
		else if(l.get_buildtype() == BWAPI::UnitTypes::Zerg_Overlord) HITAData::overload_num++;
		else if(l.get_buildtype() == BWAPI::UnitTypes::Zerg_Zergling) HITAData::zergling_num += 2;
	}


	////building̐
	BOOST_FOREACH(BuildingData &b, buildings){
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Hatchery) HITAData::hatchery_num++;
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Spawning_Pool) HITAData::pool_num++;
		if(b.get_type() == BWAPI::UnitTypes::Zerg_Extractor) HITAData::extractor_num++;
	}

	BOOST_FOREACH(WorkerData &w, workers){
		if(w.get_state() != WorkerState::Build) continue;
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Hatchery) HITAData::hatchery_num++;
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Spawning_Pool) HITAData::pool_num++;
		if(w.get_building() == BWAPI::UnitTypes::Zerg_Extractor) HITAData::extractor_num++;
	}

	want_num = build_order[HITAData::drone_num];

	want_num.base      -= HITAData::base_num;
	want_num.hatchery  -= HITAData::hatchery_num;
	want_num.overload  -= HITAData::overload_num;
	want_num.pool      -= HITAData::pool_num;
	want_num.zergling  -= HITAData::zergling_num;
	want_num.extractor -= HITAData::extractor_num;

	/*if(logging_flag2) out2 << "[want" << HITAData::drone_num << "] ";
	if(logging_flag2) out2 << "o:" << want_num.overload << " ";
	if(logging_flag2) out2 << "z:" << want_num.zergling << " ";
	if(logging_flag2) out2 << "h:" << want_num.hatchery << " ";*/



	//Gjbg̒ǉ/////////////////////////////////////////////////////////////////////////////////
	if(logging_flag) out << "7,"<< std::endl;
	BOOST_FOREACH(BWAPI::Unit * u, BWAPI::Broodwar->enemy()->getUnits()){
		if( ! u->exists() ) continue;
		if( epre_id.find(u->getID()) != epre_id.end() )  continue;
		//if(u->getType().isRefinery()) continue;

		epre_id.insert(u->getID());
		if(u->getType().isWorker()){
			eworkers.insert(WorkerData(u));
		}else if(u->getType().groundWeapon() != BWAPI::WeaponTypes::None || u->getType() == BWAPI::UnitTypes::Terran_Bunker){
			if(u->getType().airWeapon() != BWAPI::WeaponTypes::None) HITAFlag::enemy_air_weapon = true;
			eattackers.insert(AttackerData(u));
		}else if(u->getType().isBuilding()){
			ebuildings.insert(BuildingData(u));
			mapdata.set_enemybases(BWTA::getRegion(u->getPosition()));
		}else {
			eothers.insert(OtherUnitData(u));
		}
	}

	end_time = clock();
	exe_time = end_time - start_time;
	max_add = std::max(exe_time, max_add);
	BWAPI::Broodwar->drawTextScreen(430,150, "Add");
	BWAPI::Broodwar->drawTextScreen(550,150, "%f", max_add);


	//Rjbg̍XV//////////////////////////////////////////////////////////////////////
	start_time = clock();
	if(logging_flag) out << "8,"<< std::endl;
	if(!workers.empty()) 
		BOOST_FOREACH(WorkerData &w, workers) w.update();
	end_time = clock();
	exe_time = end_time - start_time;
	max_wupdate = std::max(exe_time, max_wupdate);
	BWAPI::Broodwar->drawTextScreen(430,160, "MyWorkerUpdate");
	BWAPI::Broodwar->drawTextScreen(550,160, "%f", max_wupdate);

	start_time = clock();
	if(logging_flag) out << "9,"<< std::endl;
	if(!attackers.empty())
		BOOST_FOREACH(AttackerData &a, attackers) a.update();
	end_time = clock();
	exe_time = end_time - start_time;
	max_aupdate = std::max(exe_time, max_aupdate);
	BWAPI::Broodwar->drawTextScreen(430,170, "MyAttackerUpdate");
	BWAPI::Broodwar->drawTextScreen(550,170, "%f", max_aupdate);

	start_time = clock();
	if(logging_flag) out << "10," << std::endl;
	if(!buildings.empty())
		BOOST_FOREACH(BuildingData &b, buildings) b.update();
	end_time = clock();
	exe_time = end_time - start_time;
	max_bupdate = std::max(exe_time, max_bupdate);
	BWAPI::Broodwar->drawTextScreen(430,180, "MyBuildingUpdate");
	BWAPI::Broodwar->drawTextScreen(550,180, "%f", max_bupdate);

	start_time = clock();
	if(logging_flag) out << "11,"<< std::endl;
	if(!resources.empty())
		BOOST_FOREACH(ResourceData &r, resources) r.update();
	end_time = clock();
	exe_time = end_time - start_time;
	max_rupdate = std::max(exe_time, max_rupdate);
	BWAPI::Broodwar->drawTextScreen(430,190, "MyResourceUpdate");
	BWAPI::Broodwar->drawTextScreen(550,190, "%f", max_rupdate);

	start_time = clock();
	if(logging_flag) out << "12,"<< std::endl;
	if(!larvas.empty())
		BOOST_FOREACH(LarvaData &l, larvas) l.update();
	end_time = clock();
	exe_time = end_time - start_time;
	max_lupdate = std::max(exe_time, max_lupdate);
	BWAPI::Broodwar->drawTextScreen(430,200, "MyLarvaUpdate");
	BWAPI::Broodwar->drawTextScreen(550,200, "%f", max_lupdate);

	start_time = clock();
	if(logging_flag) out << "13,"<< std::endl;
	if(!others.empty())
		BOOST_FOREACH(OtherUnitData &o, others) o.update();
	end_time = clock();
	exe_time = end_time - start_time;
	max_oupdate = std::max(exe_time, max_oupdate);
	BWAPI::Broodwar->drawTextScreen(430,210, "MyOtherUpdate");
	BWAPI::Broodwar->drawTextScreen(550,210, "%f", max_oupdate);



	//Gjbg̍XV//////////////////////////////////////////////////////////////////////
	start_time = clock();
	if(logging_flag) out << "14,"<< std::endl;
	BOOST_FOREACH(WorkerData &w, eworkers) w.eupdate();
	end_time = clock();
	exe_time = end_time - start_time;
	max_ewupdate = std::max(exe_time, max_ewupdate);
	BWAPI::Broodwar->drawTextScreen(430,220, "EnemyWorkerUpdate");
	BWAPI::Broodwar->drawTextScreen(550,220, "%f", max_ewupdate);

	start_time = clock();
	if(logging_flag) out << "15,"<< std::endl;
	//HITAData::enemy_attackers_hp = 0;
	BOOST_FOREACH(AttackerData &a, eattackers) a.eupdate();
	end_time = clock();
	exe_time = end_time - start_time;
	max_eaupdate = std::max(exe_time, max_eaupdate);
	BWAPI::Broodwar->drawTextScreen(430,230, "EnemyAttackerUpdate");
	BWAPI::Broodwar->drawTextScreen(550,230, "%f", max_eaupdate);

	start_time = clock();
	if(logging_flag) out << "16,"<< std::endl;
	BOOST_FOREACH(BuildingData &b, ebuildings) b.eupdate();
	end_time = clock();
	exe_time = end_time - start_time;
	max_ebupdate = std::max(exe_time, max_ebupdate);
	BWAPI::Broodwar->drawTextScreen(430,240, "EnemyBuildingUpdate");
	BWAPI::Broodwar->drawTextScreen(550,240, "%f", max_ebupdate);

	start_time = clock();
	if(logging_flag) out << "16-2,"<< std::endl;
	BOOST_FOREACH(OtherUnitData &o, eothers) o.eupdate();
	end_time = clock();
	exe_time = end_time - start_time;
	max_eoupdate = std::max(exe_time, max_eoupdate);
	BWAPI::Broodwar->drawTextScreen(430,250, "EnemyOtherUpdate");
	BWAPI::Broodwar->drawTextScreen(550,250, "%f", max_eoupdate);

	//Ԃɉworker𓮂//////////////////////////////////////////////////////////////////////////

	start_time = clock();
	if(logging_flag) out << "17," << &workers << " " << std::endl;

	HITAFlag::no_resource_flag = true;
	BOOST_FOREACH(ResourceData &r, resources){
		if(&r == NULL || r.get_unit() == NULL || !r.get_type().isMineralField() || r.get_remnant() <= 0 || !r.get_unit()->exists()) continue;
		HITAFlag::no_resource_flag = false;
	}


	if(!workers.empty()){
		if(logging_flag) out << workers.size() << std::endl;
		BOOST_FOREACH(WorkerData &w, workers){
			if(logging_flag) out << "w" << std::endl;
			if(&w == NULL || w.get_unit() == NULL || w.get_state() == NULL) continue;
			if(logging_flag) out << "w" << std::endl;
			//MineralFł߂ɂmineral
			if(w.get_state() == WorkerState::Mineral){
				if(HITAFlag::no_resource_flag){
					w.get_unit()->stop();
					continue;
				}
				if(logging_flag) out << "m" << std::endl;
				if(w.get_target() != NULL && w.get_target()->get_assigned_num() != -1 && w.get_target()->get_unit() != NULL /*&& w.get_target()->get_unit()->getResources() > 0 && w.get_target()->get_unit()->exists()*/){
					if(logging_flag) out << "co" << std::endl;
					//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+20, "continue %d", w.get_target()->get_assigned_num());
					//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+30, "%p", w.get_target());
					//out << w.get_unit() << std::endl;
					//out << w.get_target() << std::endl;
					//out << w.get_target()->get_unit() << std::endl;
					//out << w.get_target()->get_remnant() << std::endl;
					//out << w.get_unit()->isGatheringMinerals() << std::endl;

					if(!w.get_unit()->isGatheringMinerals()){
						//out << w.get_unit()->gather(w.get_target()->get_unit()) << std::endl;
						w.get_unit()->gather(w.get_target()->get_unit());
						com_num++;
					}
				}else{
					if(logging_flag) out << "ch" << std::endl;
					//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+20, "change");
					int min_dis = DINF, min_ass = 100;
					ResourceData *min_r = NULL;
					BOOST_FOREACH(ResourceData &r, resources){
						if(&r == NULL || r.get_unit() == NULL || !r.get_type().isMineralField() || r.get_remnant() <= 0 || !r.get_unit()->exists()) continue;
						//if(BWTA::getRegion(w.get_position()) != BWTA::getRegion(r.get_position())) continue; //same region ?
						if(min_ass > r.get_assigned_num()){
							min_ass = r.get_assigned_num();
							min_dis = (int)w.get_unit()->getDistance(r.get_position());
							min_r = &r;
						}else if(min_ass == r.get_assigned_num()){
							if(min_dis > (int)w.get_unit()->getDistance(r.get_position())){
								min_dis = (int)w.get_unit()->getDistance(r.get_position());
								min_r = &r;
							}
						}
					}

					/*if(min_r == NULL || min_r->get_unit() == NULL || w.get_target() == min_r || min_r->get_assigned_num() < 0){
						BWAPI::Unit* min_u = NULL;
						BOOST_FOREACH(BWAPI::Unit* u, BWAPI::Broodwar->getStaticMinerals()){
							bool flag = false;
							if(u == NULL || u->getResources() <= 0) continue;
							BOOST_FOREACH(ResourceData &r, resources){
								if(r.get_unit() == u) flag = true;
							}
							if(flag) continue;
							if(min_dis > (int)w.get_unit()->getDistance(u->getPosition())){
								min_dis = (int)w.get_unit()->getDistance(u->getPosition());
								min_u = u;
							}
						}

						if(min_u != NULL){
							//ResourceData new_r = ResourceData(min_u);
							resources.insert(ResourceData(min_u));
							//w.set_target(new_r);
							//new_r.add_assigned();
						}
					}*/

					/*if(min_r == NULL || min_r->get_unit() == NULL || w.get_target() == min_r || min_r->get_assigned_num() < 0){
						w.set_state(WorkerState::Attack);
					}*/

					

					if(min_r == NULL || min_r->get_unit() == NULL || w.get_target() == min_r || min_r->get_assigned_num() < 0) continue;
					if(w.get_target() != NULL) w.get_target()->sub_assigned();
					w.set_target(*min_r);
					min_r->add_assigned();
				}
				//Gas
			}else if(w.get_state() == WorkerState::Gas){
				if(w.get_target() != NULL && w.get_target()->get_unit() != NULL &&w.get_target()->get_unit()->getResources() > 0){
					if(!w.get_unit()->isGatheringGas()) w.get_unit()->gather(w.get_target()->get_unit());
				/*}else{
					BOOST_FOREACH(ResourceData &r, resources){
						if(r.get_refinery() && r.get_unit()->isCompleted() && r.get_assigned_num() < 3 && BWTA::getRegion(w.get_position()) == BWTA::getRegion(r.get_position())){
							w.set_target(r);
							r.add_assigned();
						}
					}
					if(w.get_target() == NULL){
						BOOST_FOREACH(ResourceData &r, resources){
							if(r.get_refinery() && r.get_unit()->isCompleted() && r.get_assigned_num() < 3 ){
								w.set_target(r);
								r.add_assigned();
							}
						}
					}*/
				}
			
				//Build
			}else if(w.get_state() == WorkerState::Build /*&& !w.get_unit()->isConstructing()*/){
				if(logging_flag) out << "b" << std::endl;
				if(w.get_move_to_tp() != BWAPI::TilePositions::None && w.get_move_to_tp().isValid()){  //ɌĂƂw肳Ă
					if(logging_flag) out << "co" << std::endl;
					//w.get_unit()->build(w.get_move_to_tp(), w.get_building());
					w.build();
				}else{ //ĂƂT
					if(!w.get_building().isRefinery()){
						//hatcheryŎ̊nĂ鎞Ȃ
						//out << "ch" << std::endl;
						bool new_flag = false;
						if(w.get_building().isResourceDepot()){
							bool as_flag = false;
							if(want_num.base > 0/*workers.size() >= resources.size() * 2&& attackers.size() > 0*/)
								as_flag = true;
							//std::pair<BWTA::BaseLocation*, int> mb;
							//BOOST_FOREACH(mb, mapdata.get_mybases()){
							/*BOOST_FOREACH(ResourceData &r, resources){
							if(!r.get_type().isMineralField()) continue;
							if(r.get_assigned_num() <= 1){
							as_flag = false;
							break;
							}
							}*/
							//BWAPI::Broodwar->drawTextScreen(10,270, "as : %d", as_flag);
							//if(mb.second == MyBaseProductState::Worker) as_flag = false;
							//}
							//out << "1" << std::endl;
							if(as_flag && !HITAFlag::next_mybase_flag){
								temp_next_mybase = mapdata.get_next_mybase();
								if(temp_next_mybase != NULL){
									new_flag = true;
									w.set_move_to_tp(temp_next_mybase->getTilePosition());
									mapdata.add_mybase_num();
									HITAFlag::next_mybase_flag = true;
								}
							}
						}
						//out << "2" << std::endl;

						//ȊOmybase̎̂ǂɌ
						if(!new_flag){
							//out << "3" << std::endl;
							int x = w.get_depot()->getTilePosition().x();
							int y = w.get_depot()->getTilePosition().y();
							int dx = 0,dy = 1;
							int length = 1;
							int curve = 0;
							bool first = true;
							bool success = false;
							//out << "3-1" << std::endl;

							//out << mapdata.get_mapwidth() << std::endl;
							//out << mapdata.get_mapheight() << std::endl;
							while(x >= 0 && x < mapdata.get_mapwidth() && y >= 0 && y < mapdata.get_mapheight()){
								//out << x << std::endl;
								//out << y << std::endl;
								//out << "aa" << std::endl;
								if(mapdata.get_buildable_map()[x][y]){
									//out << "bb" << std::endl;
									bool flag = true;
									for(int i=0; i<w.get_building().tileWidth(); i++){
										for(int j=0; j<w.get_building().tileHeight(); j++){
											if(x + i < 0 
												|| x + i >= mapdata.get_mapwidth() 
												|| y + j < 0 
												|| y + j >= mapdata.get_mapheight() 
												|| mapdata.get_buildable_map()[x+i][y+j] == NULL 
												|| !mapdata.get_buildable_map()[x+i][y+j]){
												flag = false;
												goto label1;
											}
										}
									}
									label1:
									//out << "cc" << std::endl;
									if(flag){
											success = true;
											break;
									}
								}

								//out << "dd" << std::endl;

								x = x + dx;
								y = y + dy;
								curve++;
								if(curve == length){
									curve = 0;
									if(!first) length++;
									first = !first;
									if(dx == 0){
										dx = dy;
										dy = 0;
									}else{
										dy = -dx;
										dx = 0;
									}
								}
								if ( length > 16 ) break;
								//out << "ee" << std::endl;
							}
							//out << "4" << std::endl;
							if(!success){
								//out << "5" << std::endl;
								w.set_state(WorkerState::None);
								playerdata.sub_build_reserv(w.get_building());
								if(w.get_building() == BWAPI::UnitTypes::Zerg_Spawning_Pool)
									HITAFlag::reserve_zerg_spawning_pool = false;
								else if(w.get_building() == BWAPI::UnitTypes::Zerg_Hatchery)
									HITAFlag::reserve_zerg_hatchery = false;
								else if(w.get_building() == BWAPI::UnitTypes::Zerg_Evolution_Chamber)
									HITAFlag::reserve_zerg_evocham = false;
								else if(w.get_building() == BWAPI::UnitTypes::Zerg_Extractor)
									HITAFlag::reserve_zerg_extractor = false;
								else if(w.get_building() == BWAPI::UnitTypes::Zerg_Queens_Nest)
									HITAFlag::reserve_zerg_queens_nest = false;
							}else{
								//out << "6" << std::endl;
								w.set_move_to_tp(BWAPI::TilePosition(x,y));
							}
						}
					}else{//Refinery
						BOOST_FOREACH(ResourceData &r, resources){
							if(r.get_unit() == NULL || r.get_type() != BWAPI::UnitTypes::Resource_Vespene_Geyser) continue;
							w.set_move_to_tp(r.get_tposition());
							break;
						}
					}
				}
				//ScoutFړInVisibleɂ悤ɂē
			/*}else if(w.get_state() == WorkerState::Scout){
				out << "c" << std::endl;
				if( w.get_now_location() == NULL
					|| (BWAPI::Broodwar->isVisible(w.get_now_location()->getTilePosition().x() - 1, w.get_now_location()->getTilePosition().y() - 1) 
					&& BWAPI::Broodwar->isVisible(w.get_now_location()->getTilePosition().x() + 5, w.get_now_location()->getTilePosition().y() - 1) 
					&& BWAPI::Broodwar->isVisible(w.get_now_location()->getTilePosition().x() - 1, w.get_now_location()->getTilePosition().y() + 5) 
					&& BWAPI::Broodwar->isVisible(w.get_now_location()->getTilePosition().x() + 5, w.get_now_location()->getTilePosition().y() + 5) )
					|| w.get_unit()->isUnderAttack()){
						w.set_now_location(mapdata.get_next_scoutgp());
				}else{
					w.get_unit()->move(w.get_now_location()->getPosition());
					BWAPI::Broodwar->drawLineMap(w.get_position().x(), w.get_position().y(), w.get_now_location()->getPosition().x(), w.get_now_location()->getPosition().y(), BWAPI::Colors::Yellow);
				}
				//SpyFG̊n邮
			}else if(w.get_state() == WorkerState::Spy){
				out << "p" << std::endl;
				BWAPI::Position p = mapdata.get_ebp(w.get_now_location(), w.get_index());
				if(w.get_position().getDistance(p) <= 100){
					if(w.get_index() >= 7){
						w.set_index(0);
					}else{
						w.set_index(w.get_index() + 1);
					}
				}
				p = mapdata.get_ebp(w.get_now_location(), w.get_index());
				BWAPI::Broodwar->drawLineMap(w.get_position().x(), w.get_position().y(), p.x(), p.y(), BWAPI::Colors::Yellow);
				ppp = p;
				w.get_unit()->move(p);*/
			}else{
			}
			if(logging_flag) out << "e" << std::endl;
		}
	}


	end_time = clock();
	exe_time = end_time - start_time;
	max_wmanage = std::max(exe_time, max_wmanage);
	BWAPI::Broodwar->drawTextScreen(430,260, "WorkerManage");
	BWAPI::Broodwar->drawTextScreen(550,260, "%f", max_wmanage);


	//ԂɉAttacker𓮂//////////////////////////////////////////////////////////////////////////////////////////////
	start_time = clock();
	
	if(logging_flag) out << "18," << &attackers << " " << std::endl;

	if(!attackers.empty()){
		if(logging_flag) out << attackers.size() << std::endl;
		BOOST_FOREACH(AttackerData &a, attackers){
			if(logging_flag) out << "a" << std::endl;
			if(&a == NULL || a.get_unit() == NULL) continue;
			if(a.get_state() == AttackerState::Attack){
				if(logging_flag) out << "at" << std::endl;
				/*if(a.get_target() == NULL 
					|| a.get_target()->getPosition() == BWAPI::Positions::None 
					|| a.get_target()->getPosition() == BWAPI::Positions::Invalid
					|| a.get_target()->getPosition() == BWAPI::Positions::Unknown
					|| a.get_position().getDistance(a.get_target()->getPosition()) >= 100) */
				a.changeTarget();

				if(a.get_target() != NULL && a.get_target()->getHitPoints() > 0 && a.get_target()->isVisible() && a.get_target()->getType() != BWAPI::UnitTypes::Resource_Vespene_Geyser){
					/*bool continue_flag = true;;
					BOOST_FOREACH(BWAPI::Unit* unit, a.get_unit()->getUnitsInRadius(100)){
						if(unit->getPlayer() == BWAPI::Broodwar->enemy())
							continue_flag = false;
					}
					/*BOOST_FOREACH(BWAPI::Unit* unit, a.get_unit()->getUnitsInRadius(300)){
						if(unit->getPlayer() == BWAPI::Broodwar->enemy() && a.get_target() == unit)
							continue_flag = true;
					}*/
					/*if(!continue_flag){
						a.set_target(NULL);
						continue;
					}*/
					if(a.get_target() != NULL && a.get_mygroup_hp() <= a.get_enemygroup_hp() && mapdata.get_mybase_state(BWTA::getNearestBaseLocation(a.get_target()->getPosition())) == -1){
						a.set_state(AttackerState::Retreat);
					}else{
						//out << "co" << std::endl;
						com_num++;
						a.attack();
					}

					
				}else{
					//BWAPI::Position base_p = BWAPI::Positions::None;
					/*std::pair<BWTA::BaseLocation*, int> mb;
					BOOST_FOREACH(mb, mapdata.get_mybases()){
						break;
					}*/
					//if(!mapdata.get_mybases().empty()) base_p = a.get_position();/*mb.first->getPosition();*/
					//if(base_p = BWAPI::Positions::None) continue;
					/*double min_dis = DINF;
					out << "a" << std::endl;
					bool attack_flag = false;
					BOOST_FOREACH(AttackerData ea, eattackers){
						if(ea.get_hp() <= 0 || ea.get_type().isFlyer()) continue;
						if(a.get_unit()->getDistance(ea.get_unit()) < min_dis){
							min_dis = a.get_unit()->getDistance(ea.get_unit());
							a.set_target(ea.get_unit());
							attack_flag = true;
						}
					}
					if(attack_flag){
						a.get_unit()->attack(a.get_target());
						continue;
					}

					out << "w" << std::endl;
					BOOST_FOREACH(WorkerData ew, eworkers){
						if(ew.get_hp() <= 0 || ew.get_type().isFlyer()) continue;
						if(a.get_unit()->getDistance(ew.get_unit()) < min_dis){
							min_dis = a.get_unit()->getDistance(ew.get_unit());
							a.set_target(ew.get_unit());
							attack_flag = true;
						}
					}
					if(attack_flag){
						a.get_unit()->attack(a.get_target());
						continue;
					}

					out << "b" << std::endl;
					BOOST_FOREACH(BuildingData eb, ebuildings){
						if(eb.get_hp() <= 0 || eb.get_type().isFlyer()) continue;
						if(a.get_unit()->getDistance(eb.get_unit()) < min_dis){
							min_dis = a.get_unit()->getDistance(eb.get_unit());
							a.set_target(eb.get_unit());
							attack_flag = true;
						}
					}
					if(attack_flag){
						a.get_unit()->attack(a.get_target());
						continue;
					}

					out << "o" << std::endl;
					BOOST_FOREACH(OtherUnitData eo, eothers){
						if(eo.get_hp() <= 0 || eo.get_type().isFlyer()) continue;
						if(a.get_unit()->getDistance(eo.get_unit()) < min_dis){
							min_dis = a.get_unit()->getDistance(eo.get_unit());
							a.set_target(eo.get_unit());
							attack_flag = true;
						}
					}
					if(attack_flag){
						a.get_unit()->attack(a.get_target());
						continue;
					}*/

					if(logging_flag) out << "m" << std::endl;
					//if(!attack_flag){
						if(mapdata.get_enemybases().size() > 0){
							a.get_unit()->move(mapdata.get_near_enemybase()->getPosition());
						}else{
							if(logging_flag) out << "xxxx" << std::endl;
							BOOST_FOREACH(BWTA::BaseLocation* b, BWTA::getStartLocations()){
								if(b == BWTA::getStartLocation(BWAPI::Broodwar->self())) continue;
								a.get_unit()->move(b->getPosition());
								com_num++;
							}
							if(logging_flag) out << "yyyy" << std::endl;
						}
					//}
				}
			}else if(a.get_state() == AttackerState::Retreat){
				if(logging_flag) out << "r" << std::endl;
				/*if(a.get_target() == NULL 
					|| a.get_target()->getPosition() == BWAPI::Positions::None 
					|| a.get_target()->getPosition() == BWAPI::Positions::Invalid
					|| a.get_target()->getPosition() == BWAPI::Positions::Unknown
					|| a.get_position().getDistance(a.get_target()->getPosition()) >= 100) */
					a.changeTarget();
				if(a.get_mygroup_hp() > a.get_enemygroup_hp()|| mapdata.get_mybase_state(BWTA::getNearestBaseLocation(a.get_target()->getPosition())) != -1){
						a.set_state(AttackerState::Attack);
				}else{
					std::pair<BWTA::BaseLocation*, int> mb;
					BOOST_FOREACH(mb, mapdata.get_mybases()){
						break;
					}
					if(!mapdata.get_mybases().empty()) a.get_unit()->move(mb.first->getPosition());
				}
			}else if(a.get_state() == AttackerState::Scout){
				if(logging_flag) out << "sc" << std::endl;
				if( a.get_now_location() == NULL
					|| (BWAPI::Broodwar->isVisible(a.get_now_location()->getTilePosition().x() - 1, a.get_now_location()->getTilePosition().y() - 1) 
					&& BWAPI::Broodwar->isVisible(a.get_now_location()->getTilePosition().x() + 5, a.get_now_location()->getTilePosition().y() - 1) 
					&& BWAPI::Broodwar->isVisible(a.get_now_location()->getTilePosition().x() - 1, a.get_now_location()->getTilePosition().y() + 5) 
					&& BWAPI::Broodwar->isVisible(a.get_now_location()->getTilePosition().x() + 5, a.get_now_location()->getTilePosition().y() + 5) )
					|| a.get_unit()->isUnderAttack()){
						a.set_now_location(mapdata.get_next_scoutgp());
				}else{
					a.get_unit()->attack(a.get_now_location()->getPosition());
					//BWAPI::Broodwar->drawLineMap(a.get_position().x(), a.get_position().y(), a.get_now_location()->getPosition().x(), a.get_now_location()->getPosition().y(), BWAPI::Colors::Yellow);
				}
			}else if(a.get_state() == AttackerState::Difense){

			}
			if(logging_flag) out << "e" << std::endl;
		}
	}

	end_time = clock();
	exe_time = end_time - start_time;
	max_amanage = std::max(exe_time, max_amanage);
	BWAPI::Broodwar->drawTextScreen(430,270, "AttackerManage");
	BWAPI::Broodwar->drawTextScreen(550,270, "%f", max_amanage);

	//ԂɉOtherUnit𓮂//////////////////////////////////////////////////////////////////////////////////////////////
	start_time = clock();
	
	if(logging_flag) out << "18-2" << std::endl;
	BOOST_FOREACH(OtherUnitData &o, others){
		if(logging_flag) out << "o" << std::endl;
		if(&o == NULL || o.get_unit() == NULL) continue;
		if(o.get_state() == OtherUnitState::AllScout){
			if(logging_flag) out << "all" << std::endl;
			if( o.get_now_location() == NULL
				|| (BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() - 1,o.get_now_location()->getTilePosition().y() - 1) 
				&& BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() + 5, o.get_now_location()->getTilePosition().y() - 1) 
				&& BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() - 1, o.get_now_location()->getTilePosition().y() + 1) 
				&& BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() + 5, o.get_now_location()->getTilePosition().y() + 5) )
				|| o.get_unit()->isUnderAttack()){
					BWTA::BaseLocation* nb = mapdata.get_next_scoutp();
					std::pair<BWTA::BaseLocation*, bool> eb;
					bool enemybase_flag = true;
					BOOST_FOREACH(eb, mapdata.get_enemybases()){
						if(eb.first != nb) continue;
						enemybase_flag = false;
						break;
					}
					if(enemybase_flag) o.set_now_location(nb);
			}else{
				o.get_unit()->move(o.get_now_location()->getPosition());
				com_num++;
				//BWAPI::Broodwar->drawLineMap(o.get_position().x(), o.get_position().y(), o.get_now_location()->getPosition().x(), o.get_now_location()->getPosition().y(), BWAPI::Colors::Yellow);
			}

		}else if(o.get_state() == OtherUnitState::Spy){
			if(logging_flag) out << "sp" << std::endl;
			o.get_unit()->move(o.get_now_location()->getPosition());
			com_num++;

		}else if(o.get_state() == OtherUnitState::AirScout){
			if(logging_flag) out << "air" << std::endl;
			if( o.get_now_location() == NULL
				|| (BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() - 1,o.get_now_location()->getTilePosition().y() - 1) 
				&& BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() + 5, o.get_now_location()->getTilePosition().y() - 1) 
				&& BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() - 1, o.get_now_location()->getTilePosition().y() + 1) 
				&& BWAPI::Broodwar->isVisible(o.get_now_location()->getTilePosition().x() + 5, o.get_now_location()->getTilePosition().y() + 5) )
				|| o.get_unit()->isUnderAttack()){
					BWTA::BaseLocation* nb = mapdata.get_next_scoutap();
					std::pair<BWTA::BaseLocation*, bool> eb;
					bool enemybase_flag = true;
					BOOST_FOREACH(eb, mapdata.get_enemybases()){
						if(eb.first != nb) continue;
						enemybase_flag = false;
						break;
					}
					if(enemybase_flag) o.set_now_location(nb);
			}else{
				o.get_unit()->move(o.get_now_location()->getPosition());
				com_num++;
				//BWAPI::Broodwar->drawLineMap(o.get_position().x(), o.get_position().y(), o.get_now_location()->getPosition().x(), o.get_now_location()->getPosition().y(), BWAPI::Colors::Yellow);
			}

			/*
			std::pair<BWTA::BaseLocation*, int> mb;
			BOOST_FOREACH(mb, mapdata.get_mybases()){
				break;
			}
			if(!mapdata.get_mybases().empty()) o.get_unit()->move(mb.first->getPosition());
			*/
		}
		if(logging_flag) out << "e" << std::endl;
	}

	end_time = clock();
	exe_time = end_time - start_time;
	max_omanage = std::max(exe_time, max_omanage);
	BWAPI::Broodwar->drawTextScreen(430,280, "OthersManage");
	BWAPI::Broodwar->drawTextScreen(550,280, "%f", max_omanage);

	//ԂɉBuilding𓮂//////////////////////////////////////////////////////////////////////////////////////////////
	start_time = clock();

	/*
	BOOST_FOREACH(BuildingData &b, buildings){
		if(b.get_state() == BuildingState::None){
			if(b.get_type() == BWAPI::UnitTypes::Zerg_Spawning_Pool){
				if(playerdata.get_mineral() >= BWAPI::UpgradeTypes::Metabolic_Boost.mineralPrice() 
					&& playerdata.get_gas() >= BWAPI::UpgradeTypes::Metabolic_Boost.gasPrice()){
					if(b.get_unit()->upgrade(BWAPI::UpgradeTypes::Metabolic_Boost)){
						playerdata.reserv_upgrade(BWAPI::UpgradeTypes::Metabolic_Boost);
						continue;
					}
				}
				if(playerdata.get_mineral() >= BWAPI::UpgradeTypes::Adrenal_Glands.mineralPrice() 
					&& playerdata.get_gas() >= BWAPI::UpgradeTypes::Adrenal_Glands.gasPrice() 
					&& HITAFlag::complete_zerg_hive){
					if(b.get_unit()->upgrade(BWAPI::UpgradeTypes::Adrenal_Glands)){
						playerdata.reserv_upgrade(BWAPI::UpgradeTypes::Adrenal_Glands);
						continue;
					}
				}

			}else if(b.get_type() == BWAPI::UnitTypes::Zerg_Evolution_Chamber){
				if(playerdata.get_mineral() >= BWAPI::UpgradeTypes::Zerg_Carapace.mineralPrice() 
					&& playerdata.get_gas() >= BWAPI::UpgradeTypes::Zerg_Carapace.gasPrice()
					&& (HITAData::zerg_carapace == 0
					|| (HITAData::zerg_carapace == 1 && HITAFlag::complete_zerg_lair)
					|| (HITAData::zerg_carapace == 2 && HITAFlag::complete_zerg_hive))){
					if(b.get_unit()->upgrade(BWAPI::UpgradeTypes::Zerg_Carapace)){
						playerdata.reserv_upgrade(BWAPI::UpgradeTypes::Zerg_Carapace);
						continue;
					}
				}
				if(playerdata.get_mineral() >= BWAPI::UpgradeTypes::Zerg_Melee_Attacks.mineralPrice() 
					&& playerdata.get_gas() >= BWAPI::UpgradeTypes::Zerg_Melee_Attacks.gasPrice()
					&& (HITAData::zerg_melee_attacke_level == 0
					|| (HITAData::zerg_melee_attacke_level == 1 && HITAFlag::complete_zerg_lair)
					|| (HITAData::zerg_melee_attacke_level == 2 && HITAFlag::complete_zerg_hive))){
					if(b.get_unit()->upgrade(BWAPI::UpgradeTypes::Zerg_Melee_Attacks)){
						playerdata.reserv_upgrade(BWAPI::UpgradeTypes::Zerg_Melee_Attacks);
					}
				}

			}else if(b.get_type() == BWAPI::UnitTypes::Zerg_Hatchery
				&& !HITAFlag::zerg_lair 
				&& !HITAFlag::complete_zerg_lair){

				if(playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Lair 
					&& playerdata.get_gas() >= BWAPI::UnitTypes::Zerg_Lair){

					if(b.get_unit()->morph(BWAPI::UnitTypes::Zerg_Lair)){
						HITAFlag::zerg_lair = true;
						playerdata.reserv(BWAPI::UnitTypes::Zerg_Lair);
						continue;
					}
				}

			}else if(b.get_type() == BWAPI::UnitTypes::Zerg_Lair 
				&& !HITAFlag::zerg_hive
				&& !HITAFlag::complete_zerg_hive
				&& HITAFlag::complete_zerg_queen_nest){

				if(playerdata.get_mineral() >= BWAPI::UnitTypes::Zerg_Hive 
					&& playerdata.get_gas() >= BWAPI::UnitTypes::Zerg_Hive){

					if(b.get_unit()->morph(BWAPI::UnitTypes::Zerg_Hive)){
						HITAFlag::zerg_hive = true;
						playerdata.reserv(BWAPI::UnitTypes::Zerg_Hive);
						continue;
					}
				}
			}
		}
	}
	*/
	end_time = clock();
	exe_time = end_time - start_time;
	max_bmanage = std::max(exe_time, max_bmanage);
	BWAPI::Broodwar->drawTextScreen(430,290, "BuildingManage");
	BWAPI::Broodwar->drawTextScreen(550,290, "%f", max_bmanage);

	//jbgY///////////////////////////////////////////////////////////////////////////////////////////
	start_time = clock();

	if(logging_flag) out << "19,"<< std::endl;
	if(logging_flag) out << larvas.size() << std::endl;
	//if(logging_flag2) out2 << "222 mineral:" << playerdata.get_mineral() << " supply:" << playerdata.get_supplyused() << "/" <<  playerdata.get_supplytotal() << " ";

	//if(logging_flag2) out2 << "[produce] size:" << larvas.size() << " ";
	BOOST_FOREACH(LarvaData &l, larvas){
		if(logging_flag2) out2 << l.get_id();
		if(l.get_type() != BWAPI::UnitTypes::Zerg_Larva) continue;
		//BWAPI::Broodwar->drawTextMap(l.get_position().x(), l.get_position().y(), "%d", l.getMorphFrame());
		/*if((l.get_buildtype() != BWAPI::UnitTypes::None && !playerdata.canMake(l.get_buildtype()) ) || BWAPI::Broodwar->getFrameCount() - l.getMorphFrame() > 60){
			if(logging_flag2) out2 << "->clear";
			l.set_buildtype(BWAPI::UnitTypes::None);
			l.setIsMorphing(false);
			l.setMorphFrame(0);
			morph_id.erase(l.get_id());
		}*/
		if(BWAPI::Broodwar->getFrameCount() - l.getMorphFrame() > BWAPI::Broodwar->getFrameCount() / 200){
			if(logging_flag2) out2 << "->clear";
			//l.set_buildtype(BWAPI::UnitTypes::None);
			//l.setIsMorphing(false);
			l.setMorphFrame(BWAPI::Broodwar->getFrameCount());
			morph_id.erase(l.get_id());
		}
		if(l.isMorphing()){
			//out2 << ",";
			continue;
		}
		if( morph_id.find(l.get_id()) != morph_id.end() ){
			//out2 << ",";
			continue;
		}
		l.setMorphFrame(BWAPI::Broodwar->getFrameCount());
		if(want_num.overload > 0 && playerdata.canMake(BWAPI::UnitTypes::Zerg_Overlord)){
			l.set_buildtype(BWAPI::UnitTypes::Zerg_Overlord);
			l.morph();
			morph_id.insert(l.get_id());
			l.setIsMorphing(true);
			//l.setMorphFrame(BWAPI::Broodwar->getFrameCount());
			playerdata.reserv(BWAPI::UnitTypes::Zerg_Overlord);
			want_num.overload--;
		}else if(want_num.zergling > 0 && playerdata.canMake(BWAPI::UnitTypes::Zerg_Zergling) && HITAFlag::complete_zerg_spawning_pool){
			l.set_buildtype(BWAPI::UnitTypes::Zerg_Zergling);
			l.morph();
			morph_id.insert(l.get_id());
			l.setIsMorphing(true);
			//l.setMorphFrame(BWAPI::Broodwar->getFrameCount());
			playerdata.reserv(BWAPI::UnitTypes::Zerg_Zergling);
			want_num.zergling -= 2;
		}else if(playerdata.canMake(BWAPI::UnitTypes::Zerg_Drone) && playerdata.orderDrone()){
			l.set_buildtype(BWAPI::UnitTypes::Zerg_Drone);
			l.morph();
			morph_id.insert(l.get_id());
			l.setIsMorphing(true);
			//l.setMorphFrame(BWAPI::Broodwar->getFrameCount());
			playerdata.reserv(BWAPI::UnitTypes::Zerg_Drone);
			break;
		}
		//out2 << ",";
	}

	//if(logging_flag2) out2 << " 333 mineral:" << playerdata.get_mineral() << " supply:" << playerdata.get_supplyused() << "/" <<  playerdata.get_supplytotal()  << " com_num:"  << com_num << std::endl;

	/*if(playerdata.get_supplytotal() + playerdata.get_build_supplytotal() - playerdata.get_supplyused() <= 4 * hatchery_num)
		HITAFlag::overload_flag = true;
	else
		HITAFlag::overload_flag = false;

	BOOST_FOREACH(LarvaData &l, larvas){
		out << "l" << std::endl;
		if(l.get_type() != BWAPI::UnitTypes::Zerg_Larva) continue;
		if(playerdata.get_supplyused() >= 400) break;
		if(l.get_buildtype() != BWAPI::UnitTypes::None){ l.morph(); continue;}
		
		if(mapdata.get_mybase_state(l.get_mybase()) == -1) continue;
		//supply̗ʂȂȂĂoverload
		if(playerdata.get_supplytotal() < 400 
			&&HITAFlag::overload_flag
			//&& playerdata.get_supplytotal() - playerdata.get_supplyused() <= 4 * hatchery_num 
			&& playerdata.get_mineral() >= 100
			/*|| (playerdata.get_supplytotal() - playerdata.get_supplyused() <= 6 * hatchery_num && playerdata.get_mineral() >= 100)){

	/*			out << "overload" << std::endl;
				if(!l.get_unit()->canIssueCommand(BWAPI::UnitCommand::morph(l.get_unit(), BWAPI::UnitTypes::Zerg_Overlord))) continue;
				l.set_buildtype(BWAPI::UnitTypes::Zerg_Overlord);
				l.get_unit()->morph(l.get_buildtype());
				HITAFlag::overload_flag = false;
				playerdata.add_build_supplytotal();
				playerdata.reserv(BWAPI::UnitTypes::Zerg_Overlord);
				break;

				//Base̐YԂɂďꍇ
		}else if(playerdata.get_supplyused() < 400 
			&& playerdata.get_mineral() >= 50
			&& !HITAFlag::overload_flag
			&& playerdata.get_supplytotal() - playerdata.get_supplyused() > 1){

				if(mapdata.get_mybase_state(l.get_mybase()) == MyBaseProductState::Worker){

					out << "drone" << std::endl;
					if(!l.get_unit()->canIssueCommand(BWAPI::UnitCommand::morph(l.get_unit(), BWAPI::UnitTypes::Zerg_Drone))) continue;
					l.set_buildtype(BWAPI::UnitTypes::Zerg_Drone);
					l.get_unit()->morph(l.get_buildtype());
					playerdata.reserv(BWAPI::UnitTypes::Zerg_Drone);
					break;

				}else if(mapdata.get_mybase_state(l.get_mybase()) == MyBaseProductState::Attacker){

					out << "zergling" << std::endl;
					if(!l.get_unit()->canIssueCommand(BWAPI::UnitCommand::morph(l.get_unit(), BWAPI::UnitTypes::Zerg_Zergling))) continue;
					l.set_buildtype(BWAPI::UnitTypes::Zerg_Zergling);
					l.get_unit()->morph(l.get_buildtype());
					playerdata.reserv(BWAPI::UnitTypes::Zerg_Zergling);
					break;

				}

				out << "e" << std::endl;
		}
	}
	*/

	end_time = clock();
	exe_time = end_time - start_time;
	max_produce = std::max(exe_time, max_produce);
	BWAPI::Broodwar->drawTextScreen(430,300, "Produce");
	BWAPI::Broodwar->drawTextScreen(550,300, "%f", max_produce);


	//fobO////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	start_time = clock();
	/*
	//Mapɕ\
	////jbg̈ʒuɏ
	if(logging_flag) out << "20" << std::endl;
	BOOST_FOREACH(WorkerData &w, workers){
		BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y(), w.get_state_char());
		BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+10, "HP:%d", w.get_hp());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()-10, w.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()-20, w.get_unit()->getType().getName().c_str());
		if(w.get_unit()->isMorphing()) BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()-10, w.get_unit()->getBuildType().c_str());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+10, "id:%d", w.get_id());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+10, "ad:%p", &w);
		//BWAPI::Broodwar->drawBoxMap(w.get_position().x() - w.get_size()[0], w.get_position().y() - w.get_size()[1], w.get_position().x() + w.get_size()[2], w.get_position().y() + w.get_size()[3], BWAPI::Colors::Green);
		if(w.get_target() != NULL) BWAPI::Broodwar->drawLineMap(w.get_position().x(), w.get_position().y(), w.get_target()->get_position().x(), w.get_target()->get_position().y(), BWAPI::Colors::Yellow);
		if(w.get_move_to_tp() != BWAPI::TilePositions::None) BWAPI::Broodwar->drawLineMap(w.get_position().x(), w.get_position().y(), w.get_move_to_tp().x()*32, w.get_move_to_tp().y()*32, BWAPI::Colors::Yellow);
	}

	BOOST_FOREACH(AttackerData &a, attackers){
		BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()-10, a.get_state_char());
		BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y(), "HP:%d", a.get_hp());
		BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+10, "%d", a.get_mygroup_hp());
		BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+20, "%d", a.get_enemygroup_hp());
		if(a.get_target() != NULL) BWAPI::Broodwar->drawLineMap(a.get_position().x(), a.get_position().y(), a.get_target()->getPosition().x(), a.get_target()->getPosition().y(), BWAPI::Colors::Yellow);
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()-20, a.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()-20, a.get_unit()->getType().getName().c_str());
		if(a.get_unit()->isMorphing()) BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()-20, a.get_unit()->getBuildType().c_str());
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+10, "id:%d", a.get_id());
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+10, "ad:%p", &a);
		//BWAPI::Broodwar->drawBoxMap(a.get_position().x() - a.get_size()[0], a.get_position().y() - a.get_size()[1], a.get_position().x() + a.get_size()[2], a.get_position().y() + a.get_size()[3], BWAPI::Colors::Green);
	}


	BOOST_FOREACH(BuildingData &b, buildings){
		BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y(), b.get_state_char());
		BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()+10, "HP:%d", b.get_hp());
		//BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()-10, b.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()+10, "id:%d", b.get_id());
		//BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()+10, "ad:%p", &b);
		//BWAPI::Broodwar->drawBoxMap(b.get_position().x() - b.get_size()[0], b.get_position().y() - b.get_size()[1], b.get_position().x() + b.get_size()[2], b.get_position().y() + b.get_size()[3], BWAPI::Colors::Green);
	}	

	BOOST_FOREACH(ResourceData &r, resources){
		BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y(), "%d", r.get_remnant());
		BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y()-10, "%d", r.get_assigned_num());
		//BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y()+10, "%p", &r);
		//BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y()-20, r.get_type().c_str());
		//BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y()-30, r.get_unit()->getType().c_str());
		//BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y()+10, "id:%d", r.get_id());
		//BWAPI::Broodwar->drawTextMap(r.get_position().x(), r.get_position().y()+10, "ad:%p", &r);
		//BWAPI::Broodwar->drawBoxMap(r.get_position().x() - r.get_size()[0], r.get_position().y() - r.get_size()[1], r.get_position().x() + r.get_size()[2], r.get_position().y() + r.get_size()[3], BWAPI::Colors::Green);
	}

	BOOST_FOREACH(LarvaData &l, larvas){
		BWAPI::Broodwar->drawTextMap(l.get_position().x(), l.get_position().y()-10, l.get_buildtype().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(l.get_position().x(), l.get_position().y()-10, l.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(l.get_position().x(), l.get_position().y()+10, "id:%d", l.get_id());
		//BWAPI::Broodwar->drawTextMap(l.get_position().x(), l.get_position().y()+10, "ad:%p", &l);
		//if(l.get_unit()->isMorphing()) BWAPI::Broodwar->drawTextMap(l.get_position().x(), l.get_position().y(), l.get_unit()->getBuildType().c_str());
		//BWAPI::Broodwar->drawBoxMap(l.get_position().x() - l.get_size()[0], l.get_position().y() - l.get_size()[1], l.get_position().x() + l.get_size()[2], l.get_position().y() + l.get_size()[3], BWAPI::Colors::Green);
	}

	BOOST_FOREACH(OtherUnitData &o, others){
		BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y(), o.get_state_char());
		BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()+10, "HP:%d", o.get_hp());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()-10, o.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()-20, o.get_unit()->getType().getName().c_str());
		if(o.get_unit()->isMorphing()) BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()-10, o.get_unit()->getBuildType().c_str());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()+10, "id:%d", o.get_id());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()+10, "ad:%p", &o);
		//BWAPI::Broodwar->drawBoxMap(o.get_position().x() - o.get_size()[0], o.get_position().y() - o.get_size()[1], o.get_position().x() + o.get_size()[2], o.get_position().y() + o.get_size()[3], BWAPI::Colors::Green);
	}

	////EnemyUnit
	BOOST_FOREACH(WorkerData &w, eworkers){
		BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y(), "Worker");
		BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+10, "HP:%d", w.get_hp());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()-10, w.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+10, "id:%d", w.get_id());
		//BWAPI::Broodwar->drawTextMap(w.get_position().x(), w.get_position().y()+10, "ad:%p", &w);
		//BWAPI::Broodwar->drawBoxMap(w.get_position().x() - w.get_size()[0], w.get_position().y() - w.get_size()[1], w.get_position().x() + w.get_size()[2], w.get_position().y() + w.get_size()[3], BWAPI::Colors::Green);
	}

	BOOST_FOREACH(AttackerData &a, eattackers){
		BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y(), "Attacker");
		BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+10, "HP:%d", a.get_hp());
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()-10, a.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+10, "id:%d", a.get_id());
		//BWAPI::Broodwar->drawTextMap(a.get_position().x(), a.get_position().y()+10, "ad:%p", &a);
		//BWAPI::Broodwar->drawBoxMap(a.get_position().x() - a.get_size()[0], a.get_position().y() - a.get_size()[1], a.get_position().x() + a.get_size()[2], a.get_position().y() + a.get_size()[3], BWAPI::Colors::Green);
	}


	BOOST_FOREACH(BuildingData &b, ebuildings){
		BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y(), "Building");
		BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()+10, "HP:%d", b.get_hp());
		//BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()-10, b.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()+10, "id:%d", b.get_id());
		//BWAPI::Broodwar->drawTextMap(b.get_position().x(), b.get_position().y()+10, "ad:%p", &b);
		//BWAPI::Broodwar->drawBoxMap(b.get_position().x() - b.get_size()[0], b.get_position().y() - b.get_size()[1], b.get_position().x() + b.get_size()[2], b.get_position().y() + b.get_size()[3], BWAPI::Colors::Green);
	}


	BOOST_FOREACH(OtherUnitData &o, eothers){
		BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y(), "Other");
		BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()+10, "HP:%d", o.get_hp());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()-10, o.get_type().getName().c_str());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()+10, "id:%d", o.get_id());
		//BWAPI::Broodwar->drawTextMap(o.get_position().x(), o.get_position().y()+10, "ad:%p", &o);
		//BWAPI::Broodwar->drawBoxMap(o.get_position().x() - o.get_size()[0], o.get_position().y() - o.get_size()[1], o.get_position().x() + o.get_size()[2], o.get_position().y() + o.get_size()[3], BWAPI::Colors::Green);
	}


	////BaseLocation̈ʒuɏ
	/*
	{
		std::pair<std::vector<int>,BWTA::BaseLocation*> m;
		BOOST_FOREACH(m, mapdata.get_gbaseframe()){
			BWAPI::Position p = m.second->getPosition();
			BWAPI::Broodwar->drawBoxMap(p.x() - TILE_SIZE*2, p.y() - TILE_SIZE*2, p.x() + TILE_SIZE*2, p.y() + TILE_SIZE*2, BWAPI::Colors::Blue);
			BWAPI::Broodwar->drawTextMap(p.x() - TILE_SIZE*2, p.y() - TILE_SIZE*2, "(%d, %d)", m.first[0], m.first[1]);
		}*

		BOOST_FOREACH(m, mapdata.get_abaseframe()){
			BWAPI::Position p = m.second->getPosition();
			BWAPI::Broodwar->drawBoxMap(p.x() - TILE_SIZE*2, p.y() - TILE_SIZE*2, p.x() + TILE_SIZE*2, p.y() + TILE_SIZE*2, BWAPI::Colors::Red);
			BWAPI::Broodwar->drawTextMap(p.x() - TILE_SIZE*2, p.y() - TILE_SIZE*2, "(%d, %d)", m.first[0], m.first[1]);
		}

		std::pair<BWTA::BaseLocation*, int> mb;
		BOOST_FOREACH(mb, mapdata.get_mybases()){
			BWAPI::Broodwar->drawTextMap(mb.first->getPosition().x() + TILE_SIZE*2 -10, mb.first->getPosition().y() - TILE_SIZE*2, "%d", mb.second);
		}
	}
	*/

	//BWAPI::Broodwar->drawCircleMap(ppp.x(), ppp.y(), 100, BWAPI::Colors::Cyan);

	/*
	//Screenɏ
	//RƓGR̃jbg\
	BWAPI::Broodwar->drawTextScreen(70, 40, "Self");                 BWAPI::Broodwar->drawTextScreen(100, 40, "Enemy");
	BWAPI::Broodwar->drawTextScreen(10, 50, "Workers");   BWAPI::Broodwar->drawTextScreen(77, 50, "%d", workers.size());             BWAPI::Broodwar->drawTextScreen(110, 50, "%d", eworkers.size());
	BWAPI::Broodwar->drawTextScreen(10, 60, "Attackers"); BWAPI::Broodwar->drawTextScreen(77, 60, "%d", attackers.size());           BWAPI::Broodwar->drawTextScreen(110, 60, "%d", eattackers.size());
//														  BWAPI::Broodwar->drawTextScreen(153, 60, "%d", HITAData::my_attackers_hp); BWAPI::Broodwar->drawTextScreen(186, 60, "%d", HITAData::enemy_attackers_hp);
	BWAPI::Broodwar->drawTextScreen(10, 70, "Buildings"); BWAPI::Broodwar->drawTextScreen(77, 70, "%d", buildings.size());           BWAPI::Broodwar->drawTextScreen(110, 70, "%d", ebuildings.size());
	BWAPI::Broodwar->drawTextScreen(10, 80, "Resources"); BWAPI::Broodwar->drawTextScreen(77, 80, "%d", resources.size());
	BWAPI::Broodwar->drawTextScreen(10, 90, "Larvas");    BWAPI::Broodwar->drawTextScreen(77, 90, "%d", larvas.size());
	BWAPI::Broodwar->drawTextScreen(10, 100, "Others");   BWAPI::Broodwar->drawTextScreen(77, 100, "%d", others.size());             BWAPI::Broodwar->drawTextScreen(110, 100, "%d", eothers.size());

	//Ŏ擾Ă鎑\
	BWAPI::Broodwar->drawTextScreen(452, 20, "%d", playerdata.get_mineral());
	BWAPI::Broodwar->drawTextScreen(520, 20, "%d", playerdata.get_gas());
	BWAPI::Broodwar->drawTextScreen(584, 20, "%d/%d", playerdata.get_supplyused(), playerdata.get_supplytotal());

	//MapŎ擾Ă{\
	BWAPI::Broodwar->drawTextScreen(10, 10, "MapSize  : %d * %d", mapdata.get_mapwidth(), mapdata.get_mapheight());
	BWAPI::Broodwar->drawTextScreen(150, 10, "CurrentFrame  : %d", BWAPI::Broodwar->getFrameCount());
	//BWAPI::Broodwar->drawTextScreen(10, 20, "GroundBase : %d  AirBase : %d", mapdata.get_gbaseframe().size(), mapdata.get_abaseframe().size());

	//mapdata
	//BWAPI::Broodwar->drawTextScreen(10, 150, "next_mybase : %d", next_mybase.size());
	BWAPI::Broodwar->drawTextScreen(10, 160, "mybase_num : %d", mapdata.get_mybase_num());
	BWAPI::Broodwar->drawTextScreen(10, 170, "mybase size : %d", mapdata.get_mybases().size());
	BWAPI::Broodwar->drawTextScreen(10, 180, "enemybase size : %d", mapdata.get_enemybases().size());
	BWAPI::Broodwar->drawTextScreen(10, 190, "no_resource_flag : %d", HITAFlag::no_resource_flag);

	////BuildOrder
	//BWAPI::Broodwar->drawTextScreen(10,200, "reserve_zerg_spawning_pool : %d", HITAFlag::reserve_zerg_spawning_pool);
	BWAPI::Broodwar->drawTextScreen(10,210, "drone");		BWAPI::Broodwar->drawTextScreen(77, 210, "%d", HITAData::drone_num);
	BWAPI::Broodwar->drawTextScreen(10,220, "base");	    BWAPI::Broodwar->drawTextScreen(77, 220, "%d", HITAData::base_num);        BWAPI::Broodwar->drawTextScreen(110, 220, "%d", want_num.base);
	BWAPI::Broodwar->drawTextScreen(10,230, "hatchery");	BWAPI::Broodwar->drawTextScreen(77, 230, "%d", HITAData::hatchery_num);    BWAPI::Broodwar->drawTextScreen(110, 230, "%d", want_num.hatchery);
	BWAPI::Broodwar->drawTextScreen(10,240, "overload");	BWAPI::Broodwar->drawTextScreen(77, 240, "%d", HITAData::overload_num);    BWAPI::Broodwar->drawTextScreen(110, 240, "%d", want_num.overload);
	BWAPI::Broodwar->drawTextScreen(10,250, "pool");	    BWAPI::Broodwar->drawTextScreen(77, 250, "%d", HITAData::pool_num);        BWAPI::Broodwar->drawTextScreen(110, 250, "%d", want_num.pool);
	BWAPI::Broodwar->drawTextScreen(10,260, "zergling");	BWAPI::Broodwar->drawTextScreen(77, 260, "%d", HITAData::zergling_num);    BWAPI::Broodwar->drawTextScreen(110, 260, "%d", want_num.zergling);
	BWAPI::Broodwar->drawTextScreen(10,270, "extractor");   BWAPI::Broodwar->drawTextScreen(77, 270, "%d", HITAData::extractor_num);   BWAPI::Broodwar->drawTextScreen(110, 270, "%d", want_num.extractor);
	BWAPI::Broodwar->drawTextScreen(10,280, "orderDrone : %d", playerdata.orderDrone());
	//BWAPI::Broodwar->drawTextScreen(10,290, "overloadCM : %d", playerdata.canMake(BWAPI::UnitTypes::Zerg_Overlord));

	//BWAPI::Broodwar->drawTextScreen(10,210, "zerg_spawning_pool : %d", HITAFlag::zerg_spawning_pool);
	//BWAPI::Broodwar->drawTextScreen(10,220, "reserve_zerg_hatchery : %d", HITAFlag::reserve_zerg_hatchery);
	//BWAPI::Broodwar->drawTextScreen(10,230, "overload_flag : %d", HITAFlag::init_overload);
	//BWAPI::Broodwar->drawTextScreen(10,240, "next_mybase_flag : %d", HITAFlag::next_mybase_flag);
	//BWAPI::Broodwar->drawTextScreen(10,250, "scout_flag : %d", HITAFlag::scout_flag);
	//BWAPI::Broodwar->drawTextScreen(10,220, "zerg_lair : %d", HITAFlag::zerg_lair);
	//BWAPI::Broodwar->drawTextScreen(10,230, "zerg hive : %d", HITAFlag::zerg_hive);
	//BWAPI::Broodwar->drawTextScreen(10,240, "reserve_zerg_queens_nest : %d", HITAFlag::reserve_zerg_queens_nest);
	//BWAPI::Broodwar->drawTextScreen(10,250, "zerg_queens_nest : %d", HITAFlag::zerg_queens_nest);
	//BWAPI::Broodwar->drawTextScreen(10,260, "complete_zerg_lair : %d", HITAFlag::complete_zerg_lair);

	//BWAPI::Broodwar->drawTextScreen(50, 130, "reserved building : %d", reservebuildings.get_rwmap().size());
	//BWAPI::Broodwar->drawTextScreen(50, 160, "BaseLocation size : %d", BWTA::getBaseLocations().size());


	/*
	for(int i=0; i<mapdata.get_mapwidth(); i++){
	for(int j=0; j<mapdata.get_mapheight(); j++){
	if(mapdata.get_buildable_map()[i][j])
	BWAPI::Broodwar->drawDotMap(i*32, j*32, BWAPI::Colors::Blue);
	else
	BWAPI::Broodwar->drawDotMap(i*32, j*32, BWAPI::Colors::Red);
	}
	}*/

	/*
	int j=0;
	BOOST_FOREACH(int id, pre_id){
	BWAPI::Broodwar->drawTextScreen(10 + j * 20, 10, "%d", id);
	j++;
	}
	*/
	end_time = clock();
	exe_time = end_time - start_time;
	max_debug = std::max(exe_time, max_debug);
	BWAPI::Broodwar->drawTextScreen(430,310, "Debug");
	BWAPI::Broodwar->drawTextScreen(550,310, "%f", max_debug);
	if(logging_flag) out << "success" << std::endl;

	all_end_time = clock();
	all_exe_time = all_end_time - all_start_time;
	max_all = std::max(all_exe_time, max_all);
	BWAPI::Broodwar->drawTextScreen(430,120, "All");
	BWAPI::Broodwar->drawTextScreen(550,120, "%f", max_all);
	if(logging_flag2) out2 << std::endl;
}

void HITAModule::onEnd(){
}