#include "BuildingData.h"

BuildingData::BuildingData(BWAPI::Unit * u) : 
	UnitData(u),
	state(BuildingState::None),
	tposition(u->getTilePosition()),
	hp(u->getHitPoints())
{
	if(u->getPlayer() == BWAPI::Broodwar->self()){
		if(get_type() == BWAPI::UnitTypes::Zerg_Spawning_Pool) HITAFlag::zerg_spawning_pool = true; //spaening pool݂̑mF
		if(get_type() == BWAPI::UnitTypes::Zerg_Queens_Nest) HITAFlag::zerg_queens_nest = true;
		if(get_type() == BWAPI::UnitTypes::Zerg_Hive) HITAFlag::complete_zerg_lair = true;
	}
	tsize[0] = get_type().tileWidth();
	tsize[1] = get_type().tileHeight();
}

BuildingData::~BuildingData(void){}


void BuildingData::update(){
	/*std::ofstream bout("build.txt", std::ios_base::binary | std::ios_base::out | std::ios_base::trunc);
	if (!bout) {
		std::cout << "***error  o̓t@CJ܂\n";
		exit(1);
	}*/

	unit_update();
	hp = get_unit()->getHitPoints();

	//ResourceDepot̎󂯂邩ǂc
	/*if(get_type().isResourceDepot()){
	for(int i = tposition.x() - 1; i < tposition.x() + tsize[0] + 1; i++){
	for(int j = tposition.y() - 1; j < tposition.y() + tsize[1] + 1; j++){
	mapdata.set_buildable_map(i,j,false);
	BWAPI::Broodwar->drawDotMap(i*TILE_SIZE, j*TILE_SIZE, BWAPI::Colors::Red);
	}
	}
	}else{*/ 
	for(int i = tposition.x(); i < tposition.x() + tsize[0]; i++){
		for(int j = tposition.y(); j < tposition.y() + tsize[1]; j++){
			mapdata.set_buildable_map(i,j,false);
			//BWAPI::Broodwar->drawDotMap(i*TILE_SIZE, j*TILE_SIZE, BWAPI::Colors::Red);
		}
	}
	//}

	//BWAPI::Broodwar->drawTextMap(get_position().x(), get_position().y() -20, "(%d,%d) %d, %d", tposition.x(), tposition.y(), tsize[0], tsize[1]);

	//building state update
	if(state == BuildingState::Completed){
		state = BuildingState::None;
		if(get_type() == BWAPI::UnitTypes::Zerg_Lair) HITAFlag::complete_zerg_lair = true;
		if(get_type() == BWAPI::UnitTypes::Zerg_Hive) HITAFlag::complete_zerg_hive = true;
		if(get_type() == BWAPI::UnitTypes::Zerg_Spawning_Pool) HITAFlag::complete_zerg_spawning_pool = true;
		if(get_type() == BWAPI::UnitTypes::Zerg_Queens_Nest) HITAFlag::complete_zerg_queen_nest = true;

	}else if(state == BuildingState::Constructing && get_unit()->isCompleted()){
		state = BuildingState::Completed;
	}else if(state == BuildingState::Execute && !(get_unit()->isTraining() || get_unit()->isResearching() || get_unit()->isUpgrading())){
		state = BuildingState::Completed;
	}else if(state == BuildingState::None && get_unit()->isConstructing()){
		state = BuildingState::Constructing;
	}else if(state == BuildingState::None && (get_unit()->isTraining() || get_unit()->isResearching() || get_unit()->isUpgrading())){
		state = BuildingState::Execute;
	}else if(state == BuildingState::None && get_type().isResourceDepot() && get_unit()->isCompleted()){
		mapdata.set_mybases(BWTA::getRegion(get_position())); //hatcheryȂΐVnȂ
		if(HITAFlag::next_mybase_flag) HITAFlag::next_mybase_flag = false;
	}
}

void  BuildingData::eupdate(){
	unit_update();
	hp = get_unit()->getHitPoints();
}

char *  BuildingData::get_state_char() const
{
	if(state == 0) return "None";
	else if(state == 1) return "Execute";
	else if(state == 2) return "Constructing";
	else if(state == 3) return "Completed";
	else return "????";
}

int  BuildingData::get_state() const
{ return state;}

int  BuildingData::get_hp() const
{ return hp;}

BWAPI::TilePosition BuildingData::get_tposition() const{
	return tposition;
}

void  BuildingData::set_state(const int &i){
	if(i >= BuildingState::Max) return;
	state = i;
	return;
}