#include "AttackerData.h"

AttackerData::AttackerData(BWAPI::Unit * u) : 
	UnitData(u),
	state(AttackerState::None),
	target(NULL),
	mygroup_hp(0),
	enemygroup_hp(0),
	now_location(NULL)
{
}

AttackerData::~AttackerData(void){}

void AttackerData::update(){
	unit_update();
	hp = get_unit()->getHitPoints();

	mygroup_hp = 0;

	BOOST_FOREACH(AttackerData &a, attackers){
		if(a.get_unit()->getType().groundWeapon() == BWAPI::WeaponTypes::None && a.get_unit()->getType().airWeapon() == BWAPI::WeaponTypes::None)
			continue;
		if(get_unit()->getPosition().getDistance(a.get_position()) > 300)
			continue;
		mygroup_hp += a.get_unit()->getHitPoints();
	}

	//^[QbgāAĂȂ΍XV
	if(target != NULL /*&& target->isVisible()*/){
		enemygroup_hp = 0;

		BOOST_FOREACH(AttackerData &a, eattackers){
			//if(a.get_unit()->getType().groundWeapon() == BWAPI::WeaponTypes::None && a.get_unit()->getType().airWeapon() == BWAPI::WeaponTypes::None)
			//continue;
			if(target->getPosition().getDistance(a.get_position()) > 300)
				continue;
			enemygroup_hp += a.get_unit()->getHitPoints() + a.get_unit()->getShields();
		}

		/*BOOST_FOREACH(AttackerData &a, attackers){
		if(a.get_unit()->getType().groundWeapon() == BWAPI::WeaponTypes::None || a.get_unit()->getType().airWeapon() == BWAPI::WeaponTypes::None)
		continue;
		if(get_unit()->getPosition().getDistance(a.get_position()) > 300)
		continue;
		a.set_enemygroup_hp(enemygroup_hp);
		}*/
	}

	/*
	if(get_unit()->getType().groundWeapon() != BWAPI::WeaponTypes::None || get_unit()->getType().airWeapon() != BWAPI::WeaponTypes::None)
	HITAData::my_attackers_hp += hp;
	*/

	if(state == AttackerState::None){//Attack\(EggłȂ)
		if(get_unit()->getType().canAttack()){
			/*if(HITAFlag::difense_flag)
			state = AttackerState::Difense;
			else*/
			state = AttackerState::Attack;
		}
	}else if(state == AttackerState::Attack /*|| state == AttackerState::Difense*/){
		if(!HITAFlag::scout_flag){
			state = AttackerState::Scout;
			HITAFlag::scout_flag = true;
		}
	}
}

void AttackerData::eupdate(){
	unit_update();
	hp = get_unit()->getHitPoints() + get_unit()->getShields();
}

char * AttackerData::get_state_char() const
{
	if(state == 0) return "None";
	else if(state == 1) return "Attack";
	else if(state == 2) return "Retreat";
	else if(state == 3) return "Scout";
	else if(state == 4) return "Difense";
	else return "????";
}

int AttackerData::get_state() const
{ return state;}

int AttackerData::get_hp()const
{ return hp;}

BWAPI::Unit * AttackerData::get_target()
{ return target;}

int AttackerData::get_mygroup_hp() const
{ return mygroup_hp;}

void AttackerData::set_mygroup_hp(int hp){
	mygroup_hp = hp;
}

int AttackerData::get_enemygroup_hp() const
{ return enemygroup_hp;}

void AttackerData::set_enemygroup_hp(int hp){
	enemygroup_hp = hp;
}

void AttackerData::set_target(BWAPI::Unit* u)
{ target = u;}

void AttackerData::set_state(const int &i){
	if(i >= AttackerState::Max) return;
	state = i;
	return;
}

BWTA::BaseLocation* AttackerData::get_now_location() const
{ return now_location;}

void AttackerData::set_now_location(BWTA::BaseLocation* b){
	now_location = b;
}

void AttackerData::changeTarget(){
	//BWAPI::Broodwar->drawTextMap(get_position().x(), get_position().y()+30, "hoge");
	double min_dis          = DINF;
	BWAPI::Unit* min_unit;

	BOOST_FOREACH(AttackerData &ea, eattackers){
		if(ea.get_hp() <= 0 || ea.get_type().isFlyer()) continue;
		if(!ea.get_unit()->isVisible()
		|| ea.get_unit()->getPosition() == BWAPI::Positions::None
		|| ea.get_unit()->getPosition() == BWAPI::Positions::Invalid
		|| ea.get_unit()->getPosition() == BWAPI::Positions::Unknown)
			continue;
		if(get_unit()->getDistance(ea.get_unit()) < min_dis){
			min_dis = get_unit()->getDistance(ea.get_unit());
			min_unit = ea.get_unit();
		}
	}

	BOOST_FOREACH(WorkerData &ew, eworkers){
		if(ew.get_hp() <= 0 || ew.get_type().isFlyer()) continue;
		if(!ew.get_unit()->isVisible()
			|| ew.get_unit()->getPosition() == BWAPI::Positions::None 
			|| ew.get_unit()->getPosition() == BWAPI::Positions::Invalid
			|| ew.get_unit()->getPosition() == BWAPI::Positions::Unknown)
			continue;
		if(get_unit()->getDistance(ew.get_unit()) + 100 < min_dis){
			min_dis = get_unit()->getDistance(ew.get_unit()) + 100;
			min_unit = ew.get_unit();
		}
	}

	BOOST_FOREACH(BuildingData &eb, ebuildings){
		if(eb.get_hp() <= 0 || eb.get_type().isFlyer()) continue;
		if(!eb.get_unit()->isVisible()
			|| eb.get_unit()->getPosition() == BWAPI::Positions::None 
			|| eb.get_unit()->getPosition() == BWAPI::Positions::Invalid
			|| eb.get_unit()->getPosition() == BWAPI::Positions::Unknown)
			continue;
		if(get_unit()->getDistance(eb.get_unit()) + 200 < min_dis){
			min_dis = get_unit()->getDistance(eb.get_unit()) + 200;
			min_unit = eb.get_unit();
		}
	}

	BOOST_FOREACH(OtherUnitData &eo, eothers){
		if(eo.get_hp() <= 0 || eo.get_type().isFlyer()) continue;
		if(!eo.get_unit()->isVisible()
			|| eo.get_unit()->getPosition() == BWAPI::Positions::None 
			|| eo.get_unit()->getPosition() == BWAPI::Positions::Invalid
			|| eo.get_unit()->getPosition() == BWAPI::Positions::Unknown) 
			continue;
		if(get_unit()->getDistance(eo.get_unit()) + 300 < min_dis){
			min_dis = get_unit()->getDistance(eo.get_unit()) + 300;
			min_unit = eo.get_unit();
		}
	}

	if(min_dis != DINF)
		target = min_unit;

}

void AttackerData::attack(){
	if(target == NULL) return;
	if(get_position().getDistance(target->getPosition()) < 100)
		get_unit()->attack(target);
	else
		get_unit()->attack(target->getPosition());
}