#include "CombatSimulation.h"

CombatSimulation::CombatSimulation()
	: hasLogged(false),
	useAlphaBeta(false),
	center(0,0)
{
	
}
//test
// sets the starting states based on the combat units within a radius of a given position
// this center will most likely be the position of the forwardmost combat unit we control
void CombatSimulation::setCombatUnits(const BWAPI::Position & center, const int radius)
{
	// store the center for later use
	this->center = center;

	MicroSearch::GameState s;
	s.setMaxUnits(100);

	BWAPI::Broodwar->drawCircleMap(center.x(), center.y(), 10, BWAPI::Colors::Red, true);

	std::vector<BWAPI::Unit *> ourCombatUnits;
	std::vector<UnitInfo> enemyCombatUnits;
	MapGrid::Instance().GetUnits(ourCombatUnits,   center, Options::Micro::COMBAT_REGROUP_RADIUS, true, false);
	InformationManager::Instance().getNearbyForce(enemyCombatUnits, center, BWAPI::Broodwar->enemy(), Options::Micro::COMBAT_REGROUP_RADIUS);


	int y = 0;

	BOOST_FOREACH (BWAPI::Unit * unit, ourCombatUnits)
	{
		if (InformationManager::Instance().isCombatUnit(unit->getType()))
		{
			s.addUnit(MicroSearch::Unit(unit, getPlayer(BWAPI::Broodwar->self()), BWAPI::Broodwar->getFrameCount()));
		}
	}

	y++;

	BOOST_FOREACH (UnitInfo ui, enemyCombatUnits)
	{
		if (!ui.type.isFlyer())
		{
			s.addUnit(getUnit(ui, getPlayer(BWAPI::Broodwar->enemy())));
		}
	}

	s.finishedMoving();

	state = s;
}

const MicroSearch::Unit CombatSimulation::getUnit(const UnitInfo & ui, const IDType & playerID) const
{
	BWAPI::UnitType type = ui.type;
	if (type == BWAPI::UnitTypes::Terran_Medic)
	{
		type = BWAPI::UnitTypes::Terran_Marine;
	}

	return MicroSearch::Unit(ui.type, MicroSearch::Position(ui.lastPosition.x(), ui.lastPosition.y()), ui.unitID, playerID, ui.lastHealth, 0,
		BWAPI::Broodwar->getFrameCount(), BWAPI::Broodwar->getFrameCount());	
}

ScoreType CombatSimulation::simulateHealthOverDPS()
{
	if (center == BWAPI::Position(0, 0)) return false;

	const IDType player = Search::Players::Player_One;
	BWAPI::Player *enemyPlayer = BWAPI::Broodwar->enemy();

	InformationManager i = InformationManager::Instance();

	double playerHealth = 0;
	double enemyHealth = 0;
	double playerDPS = 1;
	double enemyDPS = 1;

	int explosive = 0;
	int normal = 0;
	int concussive = 0;

	std::vector<BWAPI::Unit *> ourCombatUnits;
	std::vector<UnitInfo> enemyCombatUnits;

	MapGrid::Instance().GetUnits(ourCombatUnits, center, Options::Micro::COMBAT_REGROUP_RADIUS, true, false);
	i.getForce(enemyCombatUnits, enemyPlayer);


	// loop through map and only add non-workers to health and Dps total
	// test to see if we have any ground or air units
	BOOST_FOREACH(BWAPI::Unit* unit, ourCombatUnits)
	{
		if (!unit->getType().isWorker())
		{
			playerDPS += i.getDPS(unit->getType());
			playerHealth += unit->getHitPoints();
			playerHealth += unit->getShields();
		}
	}


	int buildingCount = 0;
	BOOST_FOREACH(UnitInfo unit, enemyCombatUnits)
	{
		if (!unit.type.isWorker())
		{
			BWAPI::Unit* u = unit.unit;
			BWAPI::UnitType & ut = unit.type;
			if (u->getType().isBuilding())
			{
				if (!u->isBeingConstructed())
				{
					buildingCount++;
				}
				enemyDPS += 0.5 * i.getDPS(ut);
			}
			else
			{
				enemyDPS += i.getDPS(ut);
			}
			enemyHealth += unit.lastHealth;
		}
	}
	if (buildingCount > 0)
	{
		//BWAPI::Broodwar->sendText("there is a connon");
		useAlphaBeta = true;
	}
	else
	{
		//BWAPI::Broodwar->sendText("there is no cannonc");
		useAlphaBeta = false;
	}


	BWAPI::Broodwar->drawTextScreen(240, 225, "Player Units  : %d", ourCombatUnits.size());
	BWAPI::Broodwar->drawTextScreen(240, 235, "Enemy Units  : %d", enemyCombatUnits.size());
	BWAPI::Broodwar->drawTextScreen(240, 245, "Player Health : %f", playerHealth);
	BWAPI::Broodwar->drawTextScreen(240, 255, "Enemy Health : %f", enemyHealth);
	BWAPI::Broodwar->drawTextScreen(240, 265, "Player DPS   : %f", playerDPS);
	BWAPI::Broodwar->drawTextScreen(240, 275, "Enemy DPS   : %f", enemyDPS);

	double playerRatio = playerHealth / enemyDPS;
	double enemyRatio = enemyHealth / playerDPS;

	return ScoreType(playerRatio - enemyRatio);
}


std::pair<ScoreType, ScoreType> CombatSimulation::simulateCombat()
{
	if (useAlphaBeta)
	{
		MicroSearch::GameState s1(state);
		MicroSearch::GameState s2(state);

		MicroSearch::PlayerPtr selfChase(new MicroSearch::Player_NOK_AttackDPS(getPlayer(BWAPI::Broodwar->self())));
		MicroSearch::PlayerPtr selfKiter(new MicroSearch::Player_KiterDPS(getPlayer(BWAPI::Broodwar->self())));

		MicroSearch::PlayerPtr enemyChase(new MicroSearch::Player_AttackClosest(getPlayer(BWAPI::Broodwar->enemy())));
		MicroSearch::PlayerPtr enemyKiter(new MicroSearch::Player_KiterDPS(getPlayer(BWAPI::Broodwar->enemy())));

		MicroSearch::Game gameOptimistic (s1, selfChase, enemyChase, 1000);
		MicroSearch::Game gamePessimistic(s2, selfChase, enemyKiter, 1000);

		gameOptimistic.playScripts();
		gamePessimistic.playScripts();

		ScoreType evalOptimistic =  gameOptimistic.getState().eval(Search::Players::Player_One, Search::EvaluationMethods::SumDPS).val();
		ScoreType evalPessimistic = gamePessimistic.getState().eval(Search::Players::Player_One, Search::EvaluationMethods::SumDPS).val();
		
		BWAPI::Broodwar->drawTextScreen(240, 295, "Combat Simulation Score : %d", evalOptimistic);
		BWAPI::Broodwar->drawTextScreen(240, 305, "Simulation Type : AlphaBeta");

		return std::pair<ScoreType, ScoreType>(evalOptimistic, 0);
	}
	else
	{
		ScoreType evalOptimistic = simulateHealthOverDPS();
		evalOptimistic = simulateHealthOverDPS();

		BWAPI::Broodwar->drawTextScreen(240, 295, "Combat Simulation Score : %d", evalOptimistic);
		BWAPI::Broodwar->drawTextScreen(240, 305, "Simulation Type : DPSHealthRatio");
		return std::pair<ScoreType, ScoreType>(evalOptimistic, 0);
	}
}

const MicroSearch::GameState & CombatSimulation::getState() const
{
	return state;
}

const IDType CombatSimulation::getPlayer(BWAPI::Unit * unit) const
{
	return getPlayer(unit->getPlayer());
}

const IDType CombatSimulation::getPlayer(BWAPI::Player * player) const
{
	if (player == BWAPI::Broodwar->self())
	{
		return Search::Players::Player_One;
	}
	else if (player == BWAPI::Broodwar->enemy())
	{
		return Search::Players::Player_Two;
	}

	return Search::Players::Player_None;
}

void CombatSimulation::logState(const MicroSearch::GameState & state)
{
	if (hasLogged)
	{
		return;
	}

	std::stringstream log;

	log << "State: [EVAL=" << state.evalSumDPS(0) << ", SUMSQRT=(" << state.getTotalSumDPS(0) << "," << state.getTotalSumDPS(1) << ")\n";

	for (size_t p(0); p<Search::Constants::Num_Players; ++p)
	{
		log << "Player " << p << " units:\n";

		for (size_t u(0); u<state.numUnits(p); ++u)
		{
			const MicroSearch::Unit & unit(state.getUnit(p, u));

			log << "Unit " << u << ": " << unit.name() << " [HP=" << unit.currentHP() << ", X=" << unit.x() << ", Y=" << unit.y() << "]\n";
		}
	}

	Logger::Instance().log(log.str());

	hasLogged = true;
}