#include "ValkyrieAgent.h"
#include "NavigationAgent.h"
#include "TargetingAgent.h"

ValkyrieAgent::ValkyrieAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "ValkyrieAgent";
	//Broodwar->printf("ValkyrieAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void ValkyrieAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
