#include "UltraliskAgent.h"
#include "NavigationAgent.h"
#include "TargetingAgent.h"

UltraliskAgent::UltraliskAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "UltraliskAgent";
	//Broodwar->printf("UltraliskAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void UltraliskAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	defensive = false;
	
	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
