#include "ScourgeAgent.h"
#include "NavigationAgent.h"
#include "TargetingAgent.h"

ScourgeAgent::ScourgeAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "ScourgeAgent";
	//Broodwar->printf("ScourgeAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void ScourgeAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	defensive = false;
	
	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
