#include "ReaverAgent.h"
#include "NavigationAgent.h"

ReaverAgent::ReaverAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "ReaverAgent";
	//Broodwar->printf("ReaverAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void ReaverAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	int maxLoad = 5;
	if (Broodwar->self()->getUpgradeLevel(UpgradeTypes::Reaver_Capacity) > 0)
	{
		maxLoad = 10;
	}

	if(unit->getScarabCount() < maxLoad)
	{
		if (unit->train(UnitTypes::Protoss_Scarab)) return;
	}

	defensive = false;
	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
