#ifndef __PROTOSSDEFENSIVE_H__
#define __PROTOSSDEFENSIVE_H__

#include "Commander.h"
#include "Squad.h"
#include "BaseAgent.h"
#include "Constructor.h"

using namespace BWAPI;
using namespace BWTA;
using namespace std;

/**  This is the Commander class for a defensive Protoss tactics.
 *
 * Author: Johan Hagelback (johan.hagelback@gmail.com)
 */
class ProtossDefensive : public Commander {

private:
	Squad* mainSquad;
	Squad* backupSquad;
	Squad* sc1;
	Squad* sc2;
	Squad* detectorSquad;

public:
	ProtossDefensive();

	/** Destructor. */
	~ProtossDefensive();

	/** Called each update to issue orders. */
	virtual void computeActions();

	/** Returns the unique id for this strategy. */
	static string getStrategyId()
	{
		return "ProtossDefensive";
	}
};

#endif
