#include "ProtossDefensive.h"
#include "BuildplanEntry.h"
#include "ExplorationSquad.h"
#include "ExplorationManager.h"
#include "RushSquad.h"
#include "AgentManager.h"

ProtossDefensive::ProtossDefensive()
{
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Pylon, 8));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Forge, 9));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Gateway, 9));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Assimilator, 10));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Gateway, 12));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Pylon, 14));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Cybernetics_Core, 15));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Stargate, 18));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Citadel_of_Adun, 20));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Pylon, 22));
	buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Templar_Archives, 24));
	
	mainSquad = new Squad(1, Squad::OFFENSIVE, "MainSquad", 10);
	mainSquad->addSetup(UnitTypes::Protoss_Zealot, 10);
	mainSquad->setBuildup(true);
	mainSquad->setRequired(true);
	squads.push_back(mainSquad);

	backupSquad = new RushSquad(2, "BackupSquad", 11);
	backupSquad->setRequired(false);
	backupSquad->setBuildup(true);
	squads.push_back(backupSquad);

	sc1 = new RushSquad(3, "ScoutingSquad1", 11);
	sc1->setRequired(false);
	
	sc2 = new ExplorationSquad(4, "ScoutingSquad2", 11);
	sc2->setRequired(false);
	
	noWorkers = 16;
	noWorkersPerRefinery = 3;
}

ProtossDefensive::~ProtossDefensive()
{
	for (int i = 0; i < (int)squads.size(); i++)
	{
		delete squads.at(i);
	}
	instance = NULL;
}

void ProtossDefensive::computeActions()
{
	computeActionsBase();

	int cSupply = Broodwar->self()->supplyUsed() / 2;
	int min = Broodwar->self()->minerals();
	int gas = Broodwar->self()->gas();

	if (cSupply >= 17 && stage == 0)
	{
		buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Photon_Cannon, cSupply));

		mainSquad->addSetup(UnitTypes::Protoss_Dragoon, 8);
		mainSquad->addSetup(UnitTypes::Protoss_Scout, 5);
		stage++;
	}
	if (cSupply >= 24 && stage == 1)
	{
		sc1->addSetup(UnitTypes::Protoss_Probe, 1);
		sc1->setPriority(1);
		sc1->setActivePriority(1000);
		squads.push_back(sc1);

		stage++;
	}
	if (cSupply >= 30 && stage == 2)
	{
		mainSquad->addSetup(UnitTypes::Protoss_High_Templar, 4);
		mainSquad->setBuildup(false);

		backupSquad->addSetup(UnitTypes::Protoss_Dragoon, 6);
		backupSquad->addSetup(UnitTypes::Protoss_Scout, 4);
		backupSquad->addSetup(UnitTypes::Protoss_High_Templar, 4);
		backupSquad->setBuildup(false);

		buildplan.push_back(BuildplanEntry(TechTypes::Psionic_Storm, cSupply));
		buildplan.push_back(BuildplanEntry(UpgradeTypes::Singularity_Charge, cSupply));

		stage++;
	}
	if (min > 400 && stage == 3)
	{
		buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Nexus, cSupply));
		buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Gateway, cSupply));
		buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Stargate, cSupply));
		stage++;
	}
	if (stage == 4 && min > 400 && gas > 150 && AgentManager::getInstance()->countNoFinishedUnits(UnitTypes::Protoss_Gateway) >= 3)
	{
		buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Robotics_Facility, cSupply));
		buildplan.push_back(BuildplanEntry(UnitTypes::Protoss_Observatory, cSupply));

		mainSquad->addSetup(UnitTypes::Protoss_Observer, 1);

		sc2->addSetup(UnitTypes::Protoss_Observer, 1);
		sc2->setBuildup(false);
		squads.push_back(sc2);
		
		buildplan.push_back(BuildplanEntry(UpgradeTypes::Protoss_Ground_Weapons, cSupply));
		buildplan.push_back(BuildplanEntry(UpgradeTypes::Protoss_Plasma_Shields, cSupply));
		buildplan.push_back(BuildplanEntry(UpgradeTypes::Protoss_Ground_Weapons, cSupply));
		stage++;
	}
}
