#include "MedicAgent.h"
#include "NavigationAgent.h"
#include "AgentManager.h"

MedicAgent::MedicAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "MedicAgent";
	//Broodwar->printf("MedicAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void MedicAgent::computeActions()
{
	if (unit->isIdle() || unit->isMoving())
	{
		if (checkUnitsToHeal()) return;
	}

	defensive = true;
	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}

bool MedicAgent::checkUnitsToHeal()
{
	double bestDist = -1;
	Unit* toHeal = NULL;

	vector<BaseAgent*> agents = AgentManager::getInstance()->getAgents();
	for (int i = 0; i < (int)agents.size(); i++)
	{
		BaseAgent* agent = agents.at(i);
		if (agent->isAlive() && agent->isDamaged())
		{
			if (isMedicTarget(agent->getUnit()) && agent->getUnitID() != unit->getID())
			{
				Unit* cUnit = agent->getUnit();
				if (cUnit->exists() && cUnit->getHitPoints() > 0)
			{
					double dist = unit->getDistance(cUnit);
					if (bestDist < 0 || dist < bestDist)
			{
						bestDist = dist;
						toHeal = cUnit;
					}
				}
			}
		}
	}

	if (bestDist >= 0 && toHeal != NULL)
	{
		//Broodwar->printf("[%d] Medic healing", unitID);
		unit->useTech(TechTypes::Healing, toHeal);
		return true;
	}
	
	return false;
}

bool MedicAgent::isMedicTarget(Unit* mUnit)
{
	if (!mUnit->getType().isOrganic())
	{
		//Can only heal organic units
		return false;
	}

	if (mUnit->getType().isWorker())
	{
		//We can heal workers, but no point
		//in following them
		return false;
	}

	if (!mUnit->getType().canAttack())
	{
		//Dont follow units that cant attack
		return false;
	}

	if (isOfType(mUnit, UnitTypes::Terran_Medic))
	{
		//Dont follow other medics
		return false;
	}

	if (mUnit->isLoaded())
	{
		//Dont "follow" bunkered units
		return false;
	}

	return true;
}
