#include "LurkerAgent.h"
#include "NavigationAgent.h"
#include "TargetingAgent.h"

LurkerAgent::LurkerAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "LurkerAgent";
	//Broodwar->printf("LurkerAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void LurkerAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	int eCnt = enemyGroundUnitsWithinRange(unit->getType().groundWeapon().maxRange());
	eCnt += enemyAirToGroundUnitsWithinRange(unit->getType().groundWeapon().maxRange());
	
	if (unit->isIdle() || unit->isMoving())
	{
		if (eCnt > 0 && !unit->isBurrowed())
		{
			if (unit->burrow()) return;
		}
		if (eCnt == 0 && unit->isBurrowed())
		{
			if (unit->unburrow()) return;
		}
	}

	defensive = false;
	if (!unit->isBurrowed()) defensive = true;
	
	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
