#include "FirebatAgent.h"
#include "NavigationAgent.h"
#include "AgentManager.h"
#include "Commander.h"
#include "TargetingAgent.h"

FirebatAgent::FirebatAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "FirebatAgent";
	//Broodwar->printf("FirebatAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void FirebatAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	if (unit->isIdle() || unit->isMoving())
	{
		if (!unit->isLoaded())
		{
			Squad* sq = Commander::getInstance()->getSquad(squadID);
			if (sq != NULL)
			{
				if (sq->isBunkerDefend())
				{
					vector<BaseAgent*> agents = AgentManager::getInstance()->getAgents();
					for (int i = 0; i < (int)agents.size(); i++)
					{
						if (agents.at(i)->isAlive() && agents.at(i)->isOfType(UnitTypes::Terran_Bunker) && agents.at(i)->getUnit()->exists())
						{
							if (agents.at(i)->getUnit()->getLoadedUnits().size() < 4)
							{
								unit->rightClick(agents.at(i)->getUnit());
								sq->setBunkerID(agents.at(i)->getUnitID());
								return;
							}
						}
					}
				}
			}
		}

		if (Broodwar->self()->hasResearched(TechTypes::Stim_Packs) && enemyAttackingUnitsWithinRange() > 0)
		{
			if (!unit->isStimmed() && unit->getHitPoints() >= 20 && !unit->isLoaded())
			{
				unit->useTech(TechTypes::Stim_Packs);
				//Broodwar->printf("[%d] Using stim packs", unitID);
				return;
			}
		}
	}

	defensive = false;
	if (unit->getAirWeaponCooldown() > 2 || unit->getGroundWeaponCooldown() > 2) defensive = true;
	if (unit->isLoaded()) defensive = false;

	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	if (!unit->isLoaded()) NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
