#include "DarkTemplarAgent.h"
#include "NavigationAgent.h"
#include "TargetingAgent.h"

DarkTemplarAgent::DarkTemplarAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "DarkTemplarAgent";
	//Broodwar->printf("DarkTemplarAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
}

void DarkTemplarAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	if (chargeShields()) return;

	defensive = false;
	if (!unit->isCloaked() || unit->isVisible()) defensive = true;
	
	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
