#include "CorsairAgent.h"
#include "NavigationAgent.h"
#include "TargetingAgent.h"

CorsairAgent::CorsairAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "CorsairAgent";
	//Broodwar->printf("CorsairAgent created (%s)", unit->getType().getName().c_str());
	
	goal = TilePosition(-1, -1);
	lastUseFrame = Broodwar->getFrameCount();
}

void CorsairAgent::computeActions()
{
	//Necessary to avoid cancelling attacks
	if (unit->isAttacking() || unit->isStartingAttack()) return;

	if (chargeShields()) return;

	if (unit->isIdle() || unit->isMoving())
	{
		if (Broodwar->getFrameCount() - lastUseFrame >= 40)
		{
			TechType web = TechTypes::Disruption_Web;
			if (Broodwar->self()->hasResearched(web))
			{
				if (unit->getEnergy() >= 125)
				{
					Unit* target = getClosestEnemyAirDefense(320);
					if (target != NULL)
					{
						if (target->getEnsnareTimer() == 0)
					{
							unit->useTech(web, target);
							lastUseFrame = Broodwar->getFrameCount();
							//Broodwar->printf("[%d] Using Disruption Web on %s", unitID, target->getType().getName().c_str());
							return;
						}
					}
				}
			}
		}
	}

	defensive = false;
	if (unit->getAirWeaponCooldown() > 2 || unit->getGroundWeaponCooldown() > 2) defensive = true;
	
	if (TargetingAgent::checkTarget(this)) return;

	if (searchForTargets()) return;

	NavigationAgent::getInstance()->computeMove(this, goal, defensive);
}
