#include "ComsatAgent.h"
#include "AgentManager.h"

ComsatAgent::ComsatAgent(Unit* mUnit)
{
	unit = mUnit;
	type = unit->getType();
	unitID = unit->getID();
	agentType = "ComsatAgent";

	lastSweepFrame = 0;
}

void ComsatAgent::computeActions()
{
	if (!unit->isIdle()) return;

	if (Broodwar->getFrameCount() - lastSweepFrame >= 40)
	{
		for(set<Unit*>::const_iterator i=Broodwar->enemy()->getUnits().begin();i!=Broodwar->enemy()->getUnits().end();i++)
		{
			//Enemy seen
			if ((*i)->exists())
			{
				if (((*i)->isCloaked() || (*i)->isBurrowed()) && !(*i)->isDetected())
				{
					if (unit->getEnergy() >= 50 && friendlyUnitsWithinRange((*i)->getPosition()) > 0) 
					{
						//Broodwar->printf("Use Scanner Sweep at (%d,%d), %s detected", (*i)->getPosition().x(), (*i)->getPosition().y(), (*i)->getType().getName().c_str());
						bool ok = unit->useTech(TechTypes::Scanner_Sweep, (*i)->getPosition());
						if (ok) lastSweepFrame = Broodwar->getFrameCount();
						return;
					}
				}
			}
		}
	}
}

int ComsatAgent::friendlyUnitsWithinRange(Position pos)
{
	int fCnt = 0;
	double maxRange = 384; //Range of sieged tanks
	vector<BaseAgent*> agents = AgentManager::getInstance()->getAgents();
	for (int i = 0; i < (int)agents.size(); i++)
	{
		BaseAgent* agent = agents.at(i);
		if (agent->isUnit() && agent->isAlive() && agent->getUnitType().canAttack())
		{
			double dist = agent->getUnit()->getPosition().getDistance(pos);
			if (dist <= maxRange)
			{
				fCnt++;
			}
		}
	}
	return fCnt;
}
