#pragma once

#include "Common.h"

class WalkPosition
{
public:
	int x, y;

	WalkPosition()
		: x(0), y(0)
	{ }

	WalkPosition(int x, int y)
		: x(x), y(y)
	{ }

	WalkPosition(const BWAPI::Position &p)
		: x(p.x() / 8), y(p.y() / 8)
	{ }

	WalkPosition(const BWAPI::TilePosition &p)
		: x(p.x() * 4), y(p.y() * 4)
	{ }

	inline operator BWAPI::Position()
	{
		return BWAPI::Position(x * 8, y * 8);
	}

	inline operator BWAPI::TilePosition()
	{
		return BWAPI::TilePosition(x / 4, y / 4);
	}

	inline bool operator==(const WalkPosition &v) const
	{
		return (x == v.x && y == v.y);
	}

	inline bool operator!=(const WalkPosition &v) const
	{
		return !(x == v.x && y == v.y);
	}

	inline bool operator<(const WalkPosition& v) const
	{
		if(x == v.x)
			return y < v.y;

		return x < v.x;
	}

	inline bool operator>(const WalkPosition& v) const
	{
		if(x == v.x)
			return y > v.y;

		return x > v.x;
	}

	inline BWAPI::Position getCenterPosition() const
	{
		return BWAPI::Position(x * 8 + 4, y * 8 + 4);
	}
};