#ifndef _SINGLETON_H_
#define _SINGLETON_H_

namespace utils
{
	template<class T>
	class Singleton
	{
	public:
		static T* getInstance();
		static void freeInstance();

	protected:
		Singleton(T* instance);
		~Singleton();

	private:
		T* _instance;
	};

	/////////////////////////////////////////////////////////////////////////////////
	// DEFINITIONS
	/////////////////////////////////////////////////////////////////////////////////
	template<class T>
	Singleton<T>::~Singleton()
	{
		freeInstance();
	}

	template<class T>
	Singleton<T>::Singleton( T* instance )
		: _instance(instance)
	{

	}

	template<class T>
	T* Singleton<T>::getInstance()
	{
		if(_instance)
		{
			return _instance;
		}

		NASSERT_EX(false, "Invalid Singleton Access");
		return NULL;
	}

	template<class T>
	void Singleton<T>::freeInstance()
	{
		delete _instance;
		_instance = NULL;
	}

}

#endif