#pragma once
#include "AbstractOrder.h"



class GameState
{
public:
	struct combatStats_t {
		double airDPF; // DPF = Damage Per Frame
		double groundDPF;
		double airHP;
		double groundHP;
	};
	struct unitState_t {
		uint8_t unitTypeId;
		uint8_t numUnits;
		uint8_t regionId;
		uint8_t orderId;
		uint8_t targetRegionId;
		int endFrame; // expected frame where the order is done
	};

	GameState();

	std::vector<unitState_t> friendlyUnits;
	std::vector<unitState_t> enemyUnits;
	std::set<int> regionsInCombat;
	// pair 1 = friend, pair 2 = enemy, map<int> = region id
	typedef std::map<int, std::pair<std::set<unitState_t*>, std::set<unitState_t*> > > combatList_t;
	combatList_t combatList; 

	void UpdateGameState();
	int getAbstractOrderID(int orderId, int currentRegion, int targetRegion);
	const std::string getAbstractOrderName(BWAPI::Order order, int currentRegion, int targetRegion);
	const std::string getAbstractOrderName(int abstractId);

private:
	void addUnit(unitState_t unit, std::vector<unitState_t>& vectorState);
	void expectedEndFrame();
	int getMoveTime(int unitTypeId, int regionId, int targetRegionId);
	BWAPI::Position getCenterRegionId(int regionId);
	void getCombatTime();
	void GameState::getCombatStats(combatStats_t & combatStats, BWAPI::UnitType unitType, uint8_t numUnits );
};
