#pragma once
#include "GUI/GeneratedFiles/ui_QtWindow.h"
#include "GUI/QSignal.h"
#include <BWAPI.h>
#include <BWTA.h>

class myQtApp : public QWidget, private Ui::myQtAppDLG
{
	Q_OBJECT

public:
	myQtApp(QWidget *parent = 0);

public slots:
	// Options
	void changeSpeed(int value);
	void pauseGame();

	void changeDisplayBWTA(int state);
	void changeBuildMap(int state);
	void changeGroundDPS(int state);
	void changeAirDPS(int state);
	void changeBuildOrder(int state);
	void changeRegionId(int state);

	// BWTA
	void changeBWTAdata();
	void drawPolygons(const std::set<BWTA::Polygon*>* polygons, QGraphicsScene* scene);
	void drawPolygon(BWTA::Polygon& p, QColor qc, QGraphicsScene* scene);
	void updateGameStateTable();

// 	void doSomething();
// 	void clear();
// 	void about();

private:
	QGraphicsScene * mapScene;

	// Tab BWTA -> Game State
	QStringList gameStateLabels;
};

