#include "QtWindow.h"
#include <QtGui> // including <QtGui> saves us to include every class user, <QString>, <QFileDialog>,...
#include <BWAPI.h>
#include <BWTA.h>
#include "InformationManager.h"

myQtApp::myQtApp(QWidget *parent)
{
	// this sets up GUI
	setupUi(this); 

	// -------------------- INITIALIZING VARIABLES --------------------
	// Tab Options
	chkMapAnalysisBWTA->setChecked(false);
	chkBuildMap->setChecked(PRINT_BUILD_MAP);
	chkGroundDPS->setChecked(PRINT_GROUND_DPS);
	chkAirDPS->setChecked(PRINT_AIR_DPS);
	chkBuildOrder->setChecked(PRINT_BUILD_ORDER);
	// Tab BWTA
	mapScene = new QGraphicsScene();
	chkRegionIdMap->setChecked(PRINT_REGION_ID_MAP);

	//gameStateLabels << tr("Unit type") << tr("Number") << tr("Region") << tr("Order") << tr("Order2") << tr("Target");
	gameStateLabels << tr("Unit type") << tr("Number") << tr("Region") << tr("Order") << tr("Target") << tr("End frame");
	unitsToLocationTable->setColumnCount(6);
	unitsToLocationTable->setHorizontalHeaderLabels(gameStateLabels);
	unitsToLocationTable->setColumnWidth(0,150);

	unitsToLocationTable_2->setColumnCount(6);
	unitsToLocationTable_2->setHorizontalHeaderLabels(gameStateLabels);
	unitsToLocationTable_2->setColumnWidth(0,150);

	// -------------------- SIGNLAS/SLOTS ------------------------
	// Tab Options
	connect( speedSlider, SIGNAL( valueChanged(int) ), this, SLOT( changeSpeed(int) ) ); 
	connect( pauseButton, SIGNAL( clicked() ), this, SLOT( pauseGame() ) ); 
	//connect( chkMapAnalysisBWTA, SIGNAL( stateChanged(int) ), this, SLOT( about() ) );
	connect( chkBuildMap, SIGNAL( stateChanged(int) ), this, SLOT( changeBuildMap(int) ) );
	connect( chkGroundDPS, SIGNAL( stateChanged(int) ), this, SLOT( changeGroundDPS(int) ) );
	connect( chkAirDPS, SIGNAL( stateChanged(int) ), this, SLOT( changeAirDPS(int) ) );
	connect( chkBuildOrder, SIGNAL( stateChanged(int) ), this, SLOT( changeBuildOrder(int) ) );
	// Tab BWTA
	connect( chkRegionIdMap, SIGNAL( stateChanged(int) ), this, SLOT( changeRegionId(int) ) );
	connect( informationManager->_GUIsignal, SIGNAL(mapInfoChanged()), this, SLOT(changeBWTAdata()) );
	connect( informationManager->_GUIsignal, SIGNAL(gameStateChanged()), this, SLOT(updateGameStateTable()) );
}


void myQtApp::changeSpeed(int value)
{
	BWAPI::Broodwar->setLocalSpeed(value);
	speedLabel->setText( "Game speed: " + QString::number(value) );
}

void myQtApp::pauseGame()
{
	int value = 99;

	BWAPI::Broodwar->setLocalSpeed(value);
	speedSlider->setValue(value);
	speedLabel->setText( "Game speed: " + QString::number(value) );
}

void myQtApp::changeBWTAdata()
{
	mapScene->clear();
	// draw regions
	drawPolygons(&BWTA::getUnwalkablePolygons(),mapScene);
	// draw center of choke points/regions
	double x0, y0, x1, y1;
	QPen qp(QColor(0,0,0));
	qp.setWidth(2);
	const std::set<BWTA::Chokepoint*> chokePoints = BWTA::getChokepoints();
	for(std::set<BWTA::Chokepoint*>::const_iterator c=chokePoints.begin();c!=chokePoints.end();c++) {
		x0 = (double)((*c)->getCenter().x())/8;
		y0 = (double)((*c)->getCenter().y())/8;

		const std::pair<BWTA::Region*,BWTA::Region*> regions = (*c)->getRegions();
		// draw region 1
		x1 = (double)regions.first->getCenter().x()/8;
		y1 = (double)regions.first->getCenter().y()/8;
		mapScene->addLine(QLineF(x0,y0,x1,y1),qp);
		mapScene->addEllipse(QRectF(x1-6,y1-6,12,12),QPen(QColor(0,0,255)),QBrush(QColor(0,0,255)));
		QGraphicsTextItem * io = new QGraphicsTextItem;
		io->setDefaultTextColor(QColor(0,0,255));
		io->setPos(x1,y1+6);
		io->setPlainText(QString::number(informationManager->_regionID[regions.first]));
		mapScene->addItem(io);
		// draw region 2
		x1 = (double)regions.second->getCenter().x()/8;
		y1 = (double)regions.second->getCenter().y()/8;
		mapScene->addLine(QLineF(x0,y0,x1,y1),qp);
		mapScene->addEllipse(QRectF(x1-6,y1-6,12,12),QPen(QColor(0,0,255)),QBrush(QColor(0,0,255)));
		QGraphicsTextItem * io2 = new QGraphicsTextItem;
		io2->setDefaultTextColor(QColor(0,0,255));
		io2->setPos(x1,y1+6);
		io2->setPlainText(QString::number(informationManager->_regionID[regions.second]));
		mapScene->addItem(io2);

		// draw choke point
		QGraphicsTextItem * io3 = new QGraphicsTextItem;
		io3->setDefaultTextColor(QColor(255,0,0));
		io3->setPos(x0,y0+6);
		io3->setPlainText(QString::number(informationManager->_chokePointID[*c]));
		mapScene->addItem(io3);
		mapScene->addEllipse(QRectF(x0-3,y0-3,6,6),QPen(QColor(255,0,0)),QBrush(QColor(255,0,0)));
	}

	textEdit->append( "Scene size " + QString::number(mapScene->width()) + "," + QString::number(mapScene->height()) );

	// Render map
	mapView->setScene(mapScene);
	mapView->setRenderHint(QPainter::Antialiasing);
	mapView->show();

	// Grid data
	//updateGameStateTable();
}

void myQtApp::updateGameStateTable()
{
	WaitForSingleObject(gameStateMutex,INFINITE); // wait for ownership
	std::vector<GameState::unitState_t> friendlyUnits = informationManager->gameState.friendlyUnits;
	int rows = friendlyUnits.size();
	unitsToLocationTable->setRowCount(rows);
	for( int i = 0; i < rows; ++i ) {
		BWAPI::UnitType unitType = BWAPI::UnitType(friendlyUnits[i].unitTypeId);
		//BWAPI::Order unitCommand = BWAPI::Order(friendlyUnits[i].orderId);
		//std::string unitCommand = BWAPI::Order(friendlyUnits[i].orderId).getName();
		std::string unitCommand = informationManager->gameState.getAbstractOrderName(friendlyUnits[i].orderId);
		QTableWidgetItem *item0 = new QTableWidgetItem( tr("%1").arg(unitType.getName().c_str()) );
		QTableWidgetItem *item1 = new QTableWidgetItem( tr("%1").arg(friendlyUnits[i].numUnits) );
		QTableWidgetItem *item2 = new QTableWidgetItem( tr("%1").arg(friendlyUnits[i].regionId) );
		QTableWidgetItem *item3 = new QTableWidgetItem( tr("%1").arg(unitCommand.c_str()) );
		//QTableWidgetItem *item4 = new QTableWidgetItem( tr("%1").arg(informationManager->gameState.getAbstractOrderName(unitCommand).c_str()) );
		QTableWidgetItem *item5 = new QTableWidgetItem( tr("%1").arg(friendlyUnits[i].targetRegionId) );
		int endFrame = friendlyUnits[i].endFrame;
		if (endFrame > 0) endFrame -= BWAPI::Broodwar->getFrameCount();
		QTableWidgetItem *item6 = new QTableWidgetItem( tr("%1").arg(endFrame) );
		unitsToLocationTable->setItem( i, 0, item0 );
		unitsToLocationTable->setItem( i, 1, item1 );
		unitsToLocationTable->setItem( i, 2, item2 );
		unitsToLocationTable->setItem( i, 3, item3 );
		unitsToLocationTable->setItem( i, 4, item5 );
		unitsToLocationTable->setItem( i, 5, item6 );
// 		unitsToLocationTable->setItem( i, 4, item4 );
// 		unitsToLocationTable->setItem( i, 5, item5 );
	}
	unitsToLocationTable->sortByColumn(0, Qt::AscendingOrder);

	//enemy
	std::vector<GameState::unitState_t> enemyUnits = informationManager->gameState.enemyUnits;
	rows = enemyUnits.size();
	unitsToLocationTable_2->setRowCount(rows);
	for( int i = 0; i < rows; ++i ) {
		BWAPI::UnitType unitType = BWAPI::UnitType(enemyUnits[i].unitTypeId);
		//BWAPI::Order unitCommand = BWAPI::Order(enemyUnits[i].orderId);
		//std::string unitCommand = BWAPI::Order(enemyUnits[i].orderId).getName();
		std::string unitCommand = informationManager->gameState.getAbstractOrderName(enemyUnits[i].orderId);
		QTableWidgetItem *item0 = new QTableWidgetItem( tr("%1").arg(unitType.getName().c_str()) );
		QTableWidgetItem *item1 = new QTableWidgetItem( tr("%1").arg(enemyUnits[i].numUnits) );
		QTableWidgetItem *item2 = new QTableWidgetItem( tr("%1").arg(enemyUnits[i].regionId) );
		QTableWidgetItem *item3 = new QTableWidgetItem( tr("%1").arg(unitCommand.c_str()) );
		//QTableWidgetItem *item4 = new QTableWidgetItem( tr("%1").arg(informationManager->gameState.getAbstractOrderName(unitCommand).c_str()) );
		QTableWidgetItem *item5 = new QTableWidgetItem( tr("%1").arg(enemyUnits[i].targetRegionId) );
		int endFrame = enemyUnits[i].endFrame;
		if (endFrame > 0) endFrame -= BWAPI::Broodwar->getFrameCount();
		QTableWidgetItem *item6 = new QTableWidgetItem( tr("%1").arg(endFrame) );
		unitsToLocationTable_2->setItem( i, 0, item0 );
		unitsToLocationTable_2->setItem( i, 1, item1 );
		unitsToLocationTable_2->setItem( i, 2, item2 );
		unitsToLocationTable_2->setItem( i, 3, item3 );
		unitsToLocationTable_2->setItem( i, 4, item5 );
		unitsToLocationTable_2->setItem( i, 5, item6 );
// 		unitsToLocationTable_2->setItem( i, 4, item4 );
// 		unitsToLocationTable_2->setItem( i, 5, item5 );
	}
	unitsToLocationTable_2->sortByColumn(0, Qt::AscendingOrder);
	ReleaseMutex(gameStateMutex);
}

void myQtApp::drawPolygons(const std::set<BWTA::Polygon*>* polygons, QGraphicsScene* scene)
{
	for(std::set<BWTA::Polygon*>::const_iterator i=polygons->begin();i!=polygons->end();i++) {
		BWTA::Polygon boundary = *(*i);
		drawPolygon(boundary,QColor(180,180,180),scene);
		std::vector<BWTA::Polygon> pHoles = boundary.holes;
		for(std::vector<BWTA::Polygon>::iterator h=pHoles.begin();h!=pHoles.end();h++) {
			drawPolygon(*h,QColor(255,100,255),scene);
		}
	}
}

void myQtApp::drawPolygon(BWTA::Polygon& p, QColor qc, QGraphicsScene* scene)
{
	QVector<QPointF> qp;
	for(int i=0;i<(int)p.size();i++) {
		int j=(i+1)%p.size();
		qp.push_back(QPointF(p[i].x(),p[i].y()));
	}
	scene->addPolygon(QPolygonF(qp),QPen(QColor(0,0,0)),QBrush(qc));  
}

void myQtApp::changeDisplayBWTA(int state)
{
	//textEdit->append( "Display BWTA: " + QString::number(state) );
}

void myQtApp::changeBuildMap(int state)
{
	PRINT_BUILD_MAP = !PRINT_BUILD_MAP;
}

void myQtApp::changeGroundDPS(int state)
{
	PRINT_GROUND_DPS = !PRINT_GROUND_DPS;
}

void myQtApp::changeAirDPS(int state)
{
	PRINT_AIR_DPS = !PRINT_AIR_DPS;
}

void myQtApp::changeBuildOrder(int state)
{
	PRINT_BUILD_ORDER = !PRINT_BUILD_ORDER;
}

void myQtApp::changeRegionId(int state)
{
	PRINT_REGION_ID_MAP = !PRINT_REGION_ID_MAP;
}



// void myQtApp::doSomething()
// {
// 	int value1, value2;
// 	Qt::CheckState state;
// 	QString str;
// 
// 	textEdit->append( "Path to file: " + lineEdit->text() );
// 
// 	value1 = spinBox1->value();
// 	value2 = spinBox2->value();
// 
// 	textEdit->append( "Number 1 value: " + QString::number(value1) );
// 	textEdit->append( "Number 2 value: " + QString::number(value2) );
// 
// 	state = checkBox->checkState();
// 
// 	str = "Checkbox says: ";
// 	if ( state == Qt::Checked ) str += "yes"; 
// 	else str += "no";
// 	textEdit->append( str );
// 
// 	textEdit->append( "ComboBox current text: " + comboBox->currentText() );
// 	textEdit->append( "ComboBox current item: " + QString::number(comboBox->currentIndex()) );
// }


// void myQtApp::clear()
// {
// 	textEdit->clear();
// }
// 
// 
// void myQtApp::about() 
// {
// 	QMessageBox::about(this, "About myQtApp",
//         	                 "This app was coded for educational purposes.\n"
//                            	 "Bye.\n");
// }


