#ifndef _COMBAT_AGENT_COMPONENT_H_
#define _COMBAT_AGENT_COMPONENT_H_

#include "TypedComponent.h"

namespace ComponentSystem
{
	template<ComponentType type>
	class CombatAgentComponent : TypedComponent<type>
	{
	public:
		CombatAgentComponent(CombatAgent* agent);
		~CombatAgentComponent();

		virtual void update() = 0;

	private:
		CombatAgent* _agent;
	};

	/////////////////////////////////////////////////////////////////////////////////
	// DEFINITIONS
	/////////////////////////////////////////////////////////////////////////////////
	template<ComponentType type>
	CombatAgentComponent<type>::CombatAgentComponent( CombatAgent* agent )
		: _agent(agent)
	{
		NASSERT_EX(_agent, "Error initializing Combat Agent Component");
	}

	template<ComponentType type>
	CombatAgentComponent<type>::~CombatAgentComponent()
	{
		_agent = NULL;
	}
}

#endif