#pragma once
#include <BWAPI.h>
#include "Common.h"
#include "InformationManager.h"

class CombatAgent
{
public:
	CombatAgent(BWAPI::Unit* unit);
	void inCombat(const UnitSet &enemies, class SquadAgent *squad);
	void inCombatBiological(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);
	void inCombatMarine(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);
	void inCombatMedic(const UnitSet &enemies, class SquadAgent *squad);
	void inCombatVulture(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);
	void inCombatWraith(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);
	void inCombatTank(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);
	void inCombatGhost(BWAPI::Unit *bestTarget, const UnitSet &enemies, class SquadAgent *squad);
	void inCombatDropship();
	void microScienceVessel(class SquadAgent *squad);
	void microSCV(class SquadAgent *squad);

	double computeTargetScore(BWAPI::Unit* target);
	double dps(BWAPI::Unit *unit, BWAPI::Unit *target);
	double tacticalThreat(BWAPI::Unit *unit, BWAPI::Unit *target);

	BWAPI::Unit* _unit;
	BWAPI::Unit* _lastTarget;
	bool _inCooldown;
	BWAPI::Position _lastPosition;
	int frameCreated;

	// specific tank functions
	int getEnemiesInRange(const UnitSet &enemies);
	void siegeRequest();
	bool wallNear();
	void unsiegeRequest();

	enum SiegeCondition
	{
		None,
		NullTarget,
		Enemies,
		NoEnemies
	};

	SiegeCondition _siegeState;

	// Variables for DropShip Micro:
	SquadAgent *loadedSquad;	// squad to which the loaded units belong
	bool doneLoading;
	int unloadTimer;

private:
	log4cxx::LoggerPtr _logger;
	bool _dropMine;

	bool enemyInSiegeRange(bool closeBuildings = true);
	bool onlyBuildingEnemies(const UnitSet &enemies);
	bool needCloak();
	bool needCloakWraith();
	bool allreadyFired(BWAPI::Unit* enemy);
	void isTankNear(BWAPI::Unit *bestTarget, class SquadAgent *squad);
	bool protectTank(BWAPI::Unit *bestTarget, class SquadAgent *squad);
	bool isSpiderMineNear();

};