#include "UnitPredictionManager.h"
#include "Overseer.h"

UnitPredictionManager::UnitPredictionManager(Overseer* ov)
{
	overseer = ov;
}

void UnitPredictionManager::calculate()
{
	////Broodwar->drawTextScreen(415,140, "-- predictions --");
	std::vector<UnitModel*> enemyBuildings = overseer->getUnitManager()->getEnemyBuildings();
	if(enemyBuildings.empty()) {
		return;
	}
	std::map<BWAPI::UnitType, int> possibleUnits;

	//possibleUnits[BWAPI::UnitTypes::Protoss_Zealot] = 0;
	//possibleUnits[BWAPI::UnitTypes::Protoss_Dragoon] = 0;
	//possibleUnits[BWAPI::UnitTypes::Protoss_Carrier] = 0;

	possibleUnits[BWAPI::UnitTypes::Terran_Medic] = 0;
	possibleUnits[BWAPI::UnitTypes::Terran_Marine] = 0;
	possibleUnits[BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode] = 0;
	possibleUnits[BWAPI::UnitTypes::Terran_Vulture] = 0;
	possibleUnits[BWAPI::UnitTypes::Terran_Firebat] = 0;
	possibleUnits[BWAPI::UnitTypes::Terran_Goliath] = 0;


	// so now what do we do? we go through all of the buildings we believe the enemy has
	for (vector<UnitModel*>::iterator i = enemyBuildings.begin(); i != enemyBuildings.end(); ++i)
	{
		UnitModel* cur = *i;

		// then for each of our potential units
		for (std::map<BWAPI::UnitType, int>::iterator it = possibleUnits.begin(); it != possibleUnits.end(); ++it)
		{
			// so increase the score of this unit type if we have a building that can produce it
			if(it->first.whatBuilds().first == cur->getType()) {
				it->second = it->second + 100;
			}

			// also increase the score of this unit type, if the building is in its tech prerequesites
			std::map<UnitType, int> techReqs = it->first.requiredUnits(); 
			for ( std::map<UnitType, int>::const_iterator itt = techReqs.begin(); itt != techReqs.end(); ++itt) {
				if(itt->first == cur->getType() ) {
					it->second = it->second + 75;
				}
			}

			std::set<UpgradeType> upgrades = it->first.upgrades();
			for ( std::set<UpgradeType>::const_iterator ittt = upgrades.begin(); ittt != upgrades.end(); ++ittt) {
				UpgradeType t = *ittt;
				if(t.whatUpgrades() == cur->getType()) {
					it->second = it->second + 50;
				}
			}


		}
	}

	std::vector<UnitModel*> enemyUnits = overseer->getUnitManager()->getEnemyMilitaryUnits();
	for (vector<UnitModel*>::iterator io = enemyUnits.begin(); io != enemyUnits.end(); ++io)
	{
		UnitModel* cur = *io;
		for (std::map<BWAPI::UnitType, int>::iterator iot = possibleUnits.begin(); iot != possibleUnits.end(); ++iot)
		{
			if(iot->first == cur->getType()) {
				iot->second = iot->second + 25;
			}

		}
	}

	int line = 1;
	for (std::map<BWAPI::UnitType, int>::iterator it = possibleUnits.begin(); it != possibleUnits.end(); ++it)
	{
	//	//Broodwar->drawTextScreen(415,140+(16*line), " %s %d", it->first.getName().c_str(), it->second);
		line++;
	}



}
