#pragma once
#include "BWAPI.h"
#include "UnitModel.h"
#include "UnitManager.h"
#include "BaseModel.h"
#include "GlobalConstants.h"
using namespace BWAPI;

class Overseer;

class TaskBase {
public:
	virtual bool canInitialize() = 0;
	virtual bool execute() = 0;
	virtual void monitor() = 0;
	virtual bool isExecuting() = 0;
	virtual bool isFinished() = 0;
	virtual bool isInitialized() = 0;
	virtual UnitType getBuildType() = 0;
	virtual void setTargetBase(BaseModel* b) = 0;
	BaseModel* getTargetBase() { return targetBase; };
	virtual int getTaskType() { return TASK_TYPE; };
	virtual int getTaskID() { return TASK_ID; };
	virtual void setTaskID(int val) { TASK_ID = val; };
	int getStartFrame() { return startFrame; };
	virtual void forceFinish() { initialized = true; finished = true; executing = false;};
	virtual bool isUrgent() { return urgent;};
	virtual void setUrgent(bool u) { urgent = u;};
	virtual void setPreReq(TaskBase* t) { preReq = t;};
	virtual TaskBase* getPreReq() { return preReq;};
	virtual TilePosition getTargetPos() { return position; };
private:


protected:

	bool executing;
	bool initialized;
	bool finished;
	bool urgent;
	UnitModel* subject;
	BWAPI::TilePosition position;
	BWAPI::UnitType type;
	BaseModel* targetBase;
	Overseer* overseer;
	bool resourcesReserved;
	int TASK_TYPE;
	int TASK_ID;
	int startFrame;
	TaskBase* preReq;



};