#pragma once
#include "BWAPI.h"
#include "BWTA.h"

class UnitModel;
class UnitManager;
class Army;

using namespace BWAPI;

class TargetEvaluator {

public:
	TargetEvaluator(UnitModel* o);
	TargetEvaluator(UnitManager* o);
	int calculateValueOf(UnitModel* u, int penalty);
	int calculateValueOf(UnitModel* u);
	int calculateValueOf(Unit* u);
	int calculateValueOf(Unit* u, int penalty);
	float calculateValueOf(BWTA::Region* r);
	float calculateValueOf(Army* a, BWTA::Region* r);
	float calculateEnemyDPFValueOf(BWTA::Region* r);
	float calculateDPFValueOf(Army* a);
	float calculateArmyValueOf(Army* a);
	float calculateEnemyArmyValueOf(BWTA::Region* r);

private:
	UnitModel* owner;
	UnitManager* unitManager;
	int valuePosition;
	int recentValues[10];

protected:

};