#pragma once
#include "BWAPI.h"
#include "UnitRatio.h"
#include <cmath>

class Overseer;
class TrainingTask;

class Synapse {

public:
	Synapse(Overseer* ov);
	void monitor();
	void registerNewRatio(UnitRatio* r);
	void instantiateTask();
	void calculateTaskFor(UnitType productionFacility);
	void replaceRatioAt(int id, UnitRatio* r);
	void start();
	bool isRunning();
	void stop();


	void activateFacility(UnitType t);
	void deactivateFacility(UnitType t);

	void setRallyPoint(Position p);
	void clearRallyPoint();

	void setCentralManagement(int ratioID, bool status);

private:
	Overseer* overseer;
	int activationThreshold;
	int currentDriveLevel;
	int baseDriveLevel;

	bool running;
	bool initialized;
	Position rallyLoc;
	std::vector<UnitRatio*> ratios;
	std::map<UnitType, int> temporalSpacingMap;
	std::map<UnitType, bool> activationMap;
	std::map<int, bool> centralManagementMap;

	// magic numbers
	int UNIT_VALUE;
	int DRIVE_UNDERCUT;
	int RATIO_ID;

protected:


};