#include "ScoutTask.h"
#include "Overseer.h"


ScoutTask::ScoutTask( Overseer* ov )
{
	overseer = ov;
	type == BWAPI::UnitTypes::None;
	TASK_TYPE = SCOUTING;
	initialized = false;
	executing = false;
	finished = false;
	startFrame = Broodwar->getFrameCount();
}



//************************************
// Method:    canInitialize
// FullName:  ExpandTask::canInitialize
// Access:    virtual public 
// Returns:   bool
// Comments:  none
//************************************
bool ScoutTask::canInitialize()
{
	UnitModel* bestWorker = overseer->getUnitManager()->findWorkerGlobal();

	// if we couldn't find a worker, refuse to continue
	if(bestWorker == NULL) {
		return false;
	}
	subject = bestWorker;
	initialized = true;
	//////Broodwar->sendText("scout task activated");
	return initialized;
}

//************************************
// Method:    execute
// FullName:  ExpandTask::execute
// Access:    virtual public 
// Returns:   bool
// Comments:  none
//************************************
bool ScoutTask::execute()
{
	GroundScoutBehaviour* gs = new GroundScoutBehaviour(subject, overseer->getUnitManager());
	subject->setMicroBehaviour(gs);
	subject->setCurrentTaskType(SCOUTING);
	if(subject == NULL) {
		//////Broodwar->sendText("Whahahahaaattt");
	} else {
		//Broodwar->drawCircleMap(subject->getPosition().x(), subject->getPosition().y(), 32, BWAPI::Colors::Cyan, true);
	}	
	if(subject->getMicroBehaviour() == NULL) {
		//////Broodwar->sendText("something went wrong");
	} else {
		//////Broodwar->sendText("behaviour is in order");
	}
	executing = true;
	//////Broodwar->sendText("scout task executing");
	return executing;
}

//************************************
// Method:    monitor
// FullName:  ExpandTask::monitor
// Access:    virtual public 
// Returns:   void
// Comments:  none
//************************************
void ScoutTask::monitor()
{
	//////Broodwar->sendText("scout!!");
	if(executing) {
		finished = true;
	}
}

//************************************
// Method:    isExecuting
// FullName:  ExpandTask::isExecuting
// Access:    virtual public 
// Returns:   bool
// Comments:  none
//************************************
bool ScoutTask::isExecuting()
{
	return executing;
}

//************************************
// Method:    isFinished
// FullName:  ExpandTask::isFinished
// Access:    virtual public 
// Returns:   bool
// Comments:  none
//************************************
bool ScoutTask::isFinished()
{
	return finished;
}

bool ScoutTask::isInitialized()
{
	return initialized;
}

void ScoutTask::setTargetBase( BaseModel* b )
{

}
