#pragma once
#include "MicroBehaviour.h"

class RoamingDarkTemplarMicroBehaviour : public MicroBehaviour {
public:
	RoamingDarkTemplarMicroBehaviour(UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
	virtual void pickNewExploreTarget();
	virtual void lookForAttackTarget();
	void relinquishExploreTarget();
	bool hasBeenDetected();
	int calculateTargetValue(UnitModel* um);
	void updateBlackList();
	bool isRegionBlackListed(BWTA::Region* r);

private:
	BWAPI::Position targetPosition;
	InformationCell* targetCell;
	UnitManager* unitManager;


	bool attacking;
	bool moving;
	bool waiting;

	int idleTimer;

	int waitCounter;
	std::set<UnitModel*> blacklist;

protected:


};