#pragma once
#include "MicroBehaviour.h"
#include "ParticleGenerator.h"
#include <map>

class Army;

class ReaverShuttleMicroBehaviour : public MicroBehaviour {
public:
	ReaverShuttleMicroBehaviour( UnitModel* sub , UnitManager* u);
	virtual bool execute();
	virtual void nudge();
	void setTargetArmy(Army* a);
	bool addReaver(UnitModel* r);
	void clearTargetArmy();
	void findReavers();

	void findPickupTarget();
	void pickUpReaver();

	void findDropTarget();
	void dropOffReaver();

	bool moveSafely();

private:
	BWAPI::Position targetPosition;
	UnitManager* unitManager;
	
	bool attacking;
	bool moving;
	Army* targetArmy;
	std::vector<UnitModel*> reavers;
	Unit* pickUpTarget;
	Unit* dropOffTarget;
	Position dropTargetPos;
	Position anchor;

	int dropRetries;

	bool pickingUpReaver;
	bool droppingOffReaver;

	std::map<Unit*, int> dropTimer;

protected:


};