#include "PvZGamma.h"

PvZGamma::PvZGamma( Overseer* ov )
{
	overseer = ov;
	id = HIGHLEVEL_STRAT_PVZ_GAMMA;
}

void PvZGamma::setUpBranches() { 


	/*
			Before doing anything, configure the Synapse system to maintain certain unit ratios. This can be changed in the future
			but it's best to first give it some initial idea of what we want.

			Remember we also need to send the command to turn Synapse on later, typically after our opener is done.

	*/

	Synapse* synapseCore = overseer->getUnitManager()->getSynapse();
	synapseCore->setRallyPoint((*BWTA::getStartLocation(Broodwar->self())->getRegion()->getChokepoints().begin())->getCenter());

	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Zealot, 3, 1, overseer, 0)); // 0
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_High_Templar, 10, 3, overseer, 0)); // 6
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Reaver, 5, 1, overseer, 0)); // 1
	//synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Arbiter, UnitTypes::Protoss_Dragoon, 1, 10, overseer, 0)); // 2
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::None, UnitTypes::Protoss_Observer, 0, 6, overseer, 0)); // 3
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Nexus, UnitTypes::Protoss_Gateway, 1, 3, overseer, 6)); // 4
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Reaver, UnitTypes::Protoss_Shuttle, 3, 1, overseer, 3)); // 5
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::None, UnitTypes::Protoss_Dark_Templar, 0, 6, overseer, 0)); // 3
	synapseCore->setCentralManagement(0, true);

	/*
			Finish synapse configuration
	*/

	BuildOrderTemplate* rootOpener = new BuildOrderTemplate(overseer);

	rootOpener->setTargetMineralWorkers(19);
	rootOpener->setTargetGasWorkers(3);
	rootOpener->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());

		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Forge);
		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, PAUSE_WORKER_PRODUCTION_GLOBAL));
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);

		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, RESUME_WORKER_PRODUCTION_GLOBAL));	
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Gateway);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Gateway);
		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, ACTIVATE_SYNAPSE));
		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, DISABLE_OFFENSE));

		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Cybernetics_Core);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Citadel_of_Adun);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Templar_Archives);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Robotics_Facility);
	
		rootOpener->addToOpeningSequence(TechTypes::Psionic_Storm);
		rootOpener->addToOpeningSequence(UpgradeTypes::Singularity_Charge);
	
		// first expansion
		BuildOrderTemplate* expansionBuildOrder = new BuildOrderTemplate(overseer);
		expansionBuildOrder->setTargetMineralWorkers(18);
		expansionBuildOrder->setTargetGasWorkers(3);

		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Pylon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);

		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
		expansionBuildOrder->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());
		rootOpener->addToOpeningSequenceWithGuardStrength(UnitTypes::Protoss_Nexus, -1, expansionBuildOrder);
		
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Observatory);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Robotics_Support_Bay);



		// second expansion
		expansionBuildOrder = new BuildOrderTemplate(overseer);
		expansionBuildOrder->setTargetMineralWorkers(18);
		expansionBuildOrder->setTargetGasWorkers(3);

		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Pylon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);	
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);	
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
		expansionBuildOrder->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());
		rootOpener->addToOpeningSequenceWithGuardStrengthAndPosPreference(UnitTypes::Protoss_Nexus, 3, expansionBuildOrder, true);

		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, ENABLE_OFFENSE));




		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Forge);
		rootOpener->addToOpeningSequence(new ScoutTask(overseer));

		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
		rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);

		buildOrder.push_back(rootOpener);
}

void PvZGamma::loadOpener()
{
	BaseModel* startBase = overseer->getUnitManager()->getFriendlyMainBase();
	startBase->setBuildOrderTemplate(buildOrder.at(0));
}

void PvZGamma::monitorBuildOrder()
{
	// consistency checking code?
}


