#include "PvTBeta.h"

PvTBeta::PvTBeta( Overseer* ov )
{
	overseer = ov;
	id = HIGHLEVEL_STRAT_PVT_BETA;
}

void PvTBeta::setUpBranches() { 



	/*
			Before doing anything, configure the Synapse system to maintain certain unit ratios. This can be changed in the future
			but it's best to first give it some initial idea of what we want.

			Remember we also need to send the command to turn Synapse on later, typically after our opener is done.

	*/


	Synapse* synapseCore = overseer->getUnitManager()->getSynapse();
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Zealot, 2, 1, overseer, 0));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Arbiter, UnitTypes::Protoss_Dragoon, 2, 10, overseer, 0));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Reaver, 5, 2, overseer, 0)); // 1
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Reaver, UnitTypes::Protoss_Shuttle, 3, 1, overseer, 3)); // 5
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::None, UnitTypes::Protoss_Observer, 0, 4, overseer, 0));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Nexus, UnitTypes::Protoss_Gateway, 1, 3, overseer, 8));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_High_Templar, 10, 2, overseer, 0)); // 6

	synapseCore->setCentralManagement(0, true);


	/*
			Finish synapse configuration
	*/








	BuildOrderTemplate* rootOpener = new BuildOrderTemplate(overseer);

	rootOpener->setTargetMineralWorkers(18);
	rootOpener->setTargetGasWorkers(3);
	rootOpener->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());

	//rootOpener->addToOpeningSequence(new ScoutTask(overseer));
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Gateway);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Cybernetics_Core);	
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Gateway);
		rootOpener->addToOpeningSequence(new ScoutTask(overseer));
	rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, PAUSE_WORKER_PRODUCTION_GLOBAL));
	rootOpener->addToOpeningSequence(UpgradeTypes::Singularity_Charge);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Dragoon);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Dragoon);
	rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, ACTIVATE_SYNAPSE));
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Dragoon);


	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Dragoon);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Dragoon);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Zealot);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Zealot);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Forge);
		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, RESUME_WORKER_PRODUCTION_GLOBAL));
	BuildOrderTemplate* expansionBuildOrder = new BuildOrderTemplate(overseer);
	expansionBuildOrder->setTargetMineralWorkers(18);
	expansionBuildOrder->setTargetGasWorkers(3);

	expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Pylon);
	expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
	expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);	
	expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
	expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
	expansionBuildOrder->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());
	rootOpener->addToOpeningSequenceWithGuardStrength(UnitTypes::Protoss_Nexus, 0, expansionBuildOrder);

	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Robotics_Facility);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Robotics_Support_Bay);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Forge);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Citadel_of_Adun);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Templar_Archives);
	rootOpener->addToOpeningSequence(TechTypes::Psionic_Storm);

	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Observatory);
	rootOpener->addToOpeningSequence(UpgradeTypes::Leg_Enhancements);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
	
	buildOrder.push_back(rootOpener);


	/*
		Note: Still really not sure how to do this!
		We basically need a decision tree where each node is a build order fragment
		then we need each edge to be a decision made by much smarter parts of the
		architecture.
	*/
	//BuildOrderTemplate* firstBranchBuildOrder = new BuildOrderTemplate(overseer);
	//BuildOrderTemplate* secondBranchBuildOrder = new BuildOrderTemplate(overseer);

}

void PvTBeta::loadOpener()
{
	BaseModel* startBase = overseer->getUnitManager()->getFriendlyMainBase();
	startBase->setBuildOrderTemplate(buildOrder.at(0));
}

void PvTBeta::monitorBuildOrder()
{
	// consistency checking code?
}


