#include "PvTAlpha.h"

PvTAlpha::PvTAlpha( Overseer* ov )
{
	overseer = ov;
	id = HIGHLEVEL_STRAT_PVT_ALPHA;
}

void PvTAlpha::setUpBranches() { 



	/*
			Before doing anything, configure the Synapse system to maintain certain unit ratios. This can be changed in the future
			but it's best to first give it some initial idea of what we want.

			Remember we also need to send the command to turn Synapse on later, typically after our opener is done.

	*/


	Synapse* synapseCore = overseer->getUnitManager()->getSynapse();
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Zealot, 2, 1, overseer, 0));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Arbiter, UnitTypes::Protoss_Dragoon, 2, 10, overseer, 0));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::None, UnitTypes::Protoss_Observer, 0, 4, overseer, 0));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Nexus, UnitTypes::Protoss_Gateway, 1, 3, overseer, 6));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Dark_Templar, 10, 2, overseer, 8));
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Dragoon, UnitTypes::Protoss_Reaver, 8, 2, overseer, 0)); // 1
	synapseCore->registerNewRatio(new UnitRatio(UnitTypes::Protoss_Reaver, UnitTypes::Protoss_Shuttle, 3, 1, overseer, 3)); // 
	overseer->getUnitManager()->setPreferredDTStrat(PROTOSS_HARASSING_DARK_TEMPLAR);



	/*
			Finish synapse configuration
	*/








	BuildOrderTemplate* rootOpener = new BuildOrderTemplate(overseer);

	rootOpener->setTargetMineralWorkers(17);
	rootOpener->setTargetGasWorkers(3);
	rootOpener->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Gateway);
	rootOpener->addToOpeningSequence(new ScoutTask(overseer));
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Cybernetics_Core);	
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
	
	rootOpener->addToOpeningSequenceWithRally(UnitTypes::Protoss_Dragoon, RALLY_NATURAL);
	rootOpener->addToOpeningSequenceWithRally(UnitTypes::Protoss_Dragoon, RALLY_NATURAL);
		// first expansion
		BuildOrderTemplate* expansionBuildOrder = new BuildOrderTemplate(overseer);
		expansionBuildOrder->setTargetMineralWorkers(16);
		expansionBuildOrder->setTargetGasWorkers(3);

		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Pylon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);	
		expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
				expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
		expansionBuildOrder->setTargetParent(overseer->getUnitManager()->getFriendlyMainBase());
		rootOpener->addToOpeningSequenceWithGuardStrength(UnitTypes::Protoss_Nexus, 0, expansionBuildOrder);



	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Forge);

	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Citadel_of_Adun);
	rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, ALTER_WORKER_CAP, 19));

	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Templar_Archives);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Robotics_Facility);
		rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, ACTIVATE_SYNAPSE));
	rootOpener->addToOpeningSequenceWithRally(UnitTypes::Protoss_Dragoon, RALLY_NATURAL);

	expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Gateway);
	rootOpener->addToOpeningSequence(UpgradeTypes::Singularity_Charge);


	rootOpener->addToOpeningSequence(new DTDropHarassTask(overseer->getUnitManager()->getFriendlyMainBase(), overseer));
	rootOpener->addToOpeningSequence(new InternalStateChangeTask(overseer, SWITCH_PREFERRED_DT_STRAT, PROTOSS_ROAMING_DARK_TEMPLAR));


	
	// now build an assimilator at the expansion, as our gas costs will increase
	//expansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Assimilator);
	
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Forge);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Stargate);
	overseer->getUnitManager()->setMaximumBuildConstraint(UnitTypes::Protoss_Stargate, 1);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Observatory);	
	overseer->getUnitManager()->setMaximumBuildConstraint(UnitTypes::Protoss_Observatory, 1);
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Arbiter_Tribunal);
		rootOpener->addToOpeningSequence(UnitTypes::Protoss_Robotics_Support_Bay);
	overseer->getUnitManager()->setMaximumBuildConstraint(UnitTypes::Protoss_Arbiter_Tribunal, 1);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);

	rootOpener->addToOpeningSequence(TechTypes::Stasis_Field);	

	/*
	BuildOrderTemplate* secondExpansionBuildOrder = new BuildOrderTemplate(overseer);
	
	secondExpansionBuildOrder->setTargetMineralWorkers(18);
	secondExpansionBuildOrder->setTargetGasWorkers(2);

	secondExpansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Pylon);
	secondExpansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
	secondExpansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);	
	secondExpansionBuildOrder->addToOpeningSequence(UnitTypes::Protoss_Photon_Cannon);
	
	rootOpener->addToOpeningSequence(UnitTypes::Protoss_Nexus, secondExpansionBuildOrder);
	*/
	rootOpener->addToOpeningSequence(UpgradeTypes::Leg_Enhancements);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Weapons);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Ground_Armor);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
	rootOpener->addToOpeningSequence(UpgradeTypes::Protoss_Plasma_Shields);
	
	buildOrder.push_back(rootOpener);


	/*
		Note: Still really not sure how to do this!
		We basically need a decision tree where each node is a build order fragment
		then we need each edge to be a decision made by much smarter parts of the
		architecture.
	*/
	//BuildOrderTemplate* firstBranchBuildOrder = new BuildOrderTemplate(overseer);
	//BuildOrderTemplate* secondBranchBuildOrder = new BuildOrderTemplate(overseer);

}

void PvTAlpha::loadOpener()
{
	BaseModel* startBase = overseer->getUnitManager()->getFriendlyMainBase();
	startBase->setBuildOrderTemplate(buildOrder.at(0));
}

void PvTAlpha::monitorBuildOrder()
{
	// consistency checking code?
}


