#pragma once
#include "BWAPI.h"
#include "BWTA.h"
#include <cmath>
#include <map>
#include <vector>

class UnitManager;
using namespace BWAPI;
using namespace BWTA;

class PathRepository {
public:
	PathRepository();
	std::vector<TilePosition> getPathGround(BWTA::Region* start, BWTA::Region* end);
	void registerPathGround(BWTA::Region* start, BWTA::Region* end, std::vector<TilePosition> path);
	bool hasPathGround(BWTA::Region* start, BWTA::Region* end);

	std::vector<TilePosition> getPathAir(BWTA::Region* start, BWTA::Region* end);
	void registerPathAir(BWTA::Region* start, BWTA::Region* end, std::vector<TilePosition> path);
	bool hasPathAir(BWTA::Region* start, BWTA::Region* end);

private:
	std::map<std::pair<BWTA::Region*,BWTA::Region*>,std::vector<TilePosition>> pathMapGround;
	std::map<std::pair<BWTA::Region*,BWTA::Region*>,std::vector<TilePosition>> pathMapAir;

protected:

};