#include "PathRepository.h"

PathRepository::PathRepository()
{

}

std::vector<TilePosition> PathRepository::getPathGround( BWTA::Region* start, BWTA::Region* end )
{
	std::pair<BWTA::Region*, BWTA::Region*> se;
	se.first = start;
	se.second = end;
	return pathMapGround[se];
}

void PathRepository::registerPathGround( BWTA::Region* start, BWTA::Region* end, std::vector<TilePosition> path )
{
	std::pair<BWTA::Region*, BWTA::Region*> se;
	se.first = start;
	se.second = end;
	pathMapGround[se] = path;
}

bool PathRepository::hasPathGround( BWTA::Region* start, BWTA::Region* end )
{
	std::pair<BWTA::Region*, BWTA::Region*> se;
	se.first = start;
	se.second = end;
	if(pathMapGround[se].empty()) {
		return false;
	} else {
		return true;
	}
}

std::vector<TilePosition> PathRepository::getPathAir( BWTA::Region* start, BWTA::Region* end )
{
	std::pair<BWTA::Region*, BWTA::Region*> se;
	se.first = start;
	se.second = end;
	return pathMapAir[se];
}

void PathRepository::registerPathAir( BWTA::Region* start, BWTA::Region* end, std::vector<TilePosition> path )
{
	std::pair<BWTA::Region*, BWTA::Region*> se;
	se.first = start;
	se.second = end;
	pathMapAir[se] = path;

}

bool PathRepository::hasPathAir( BWTA::Region* start, BWTA::Region* end )
{
	std::pair<BWTA::Region*, BWTA::Region*> se;
	se.first = start;
	se.second = end;
	if(pathMapAir[se].empty()) {
		return false;
	} else {
		return true;
	}
}

