#pragma once
#include "tinyxml.h" 
#include "BWAPI.h"
#include "GlobalConstants.h"
#include <iostream>
#include <fstream>
#include "dirent.h"
#include <string>
#include <vector>
#include <algorithm>
#include <cctype>
using namespace BWAPI;
using namespace std;

class PastPerformanceManager {

public:
	PastPerformanceManager();
	void registerNewGameResult(std::string oname, int sused, int winloss, int score, std::pair<int, int> mdim);
	int getMostSuccessfulStrat(std::string oname);

	bool matchesDefaultAI(std::string oname);
	int returnRandomStrategy();
	bool mapDimensionsEquivalent(std::pair<int,int> a, std::pair<int,int> b);
	int returnLastRoundNumber();

	// method taken from Matt Dawson: http://www.mdawson.net/misc/readDirectory.php
	std::vector<std::string> readDirectory(const std::string &directoryLocation, const std::string &extension);

	///StrToLower converts a std::string to lowercase
	//From http://www.richelbilderbeek.nl/CppStrToLower.htm
	const std::string strToLower(std::string s);


private:
	int lastRoundNumber;
	int MAX_ROUND_WINDOW;

	std::string rdir;
	std::string wdir;

protected:


};