#include "ParticleGenerator.h"

ParticleGenerator::ParticleGenerator( int psize, int pvariance, BWAPI::Position cp)
{
	populationSize = psize;
	populationVariance = pvariance;
	centrePoint = cp;
}

//************************************
// Method:    generate
// FullName:  ParticleGenerator::generate
// Access:    public 
// Returns:   std::vector<BWAPI::Position>
// Comments:  none
//************************************
std::vector<BWAPI::Position> ParticleGenerator::generate()
{
	std::vector<BWAPI::Position> population;
	for(int i = 0; i < populationSize; i++) {
		int newX = (rand()%populationVariance);
		int newY = (rand()%populationVariance);
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		BWAPI::Position newPos = BWAPI::Position(centrePoint.x()+newX, centrePoint.y()+newY);
		if(newPos.isValid()) {
			population.push_back(newPos);
		} else {
			i--;
		}
	}
	return population;
}

//************************************
// Method:    setPopulationSize
// FullName:  ParticleGenerator::setPopulationSize
// Access:    public 
// Returns:   void
// Parameter: int ps
// Comments:  none
//************************************
void ParticleGenerator::setPopulationSize( int ps )
{
	populationSize = ps;
}

//************************************
// Method:    setPopulationVariance
// FullName:  ParticleGenerator::setPopulationVariance
// Access:    public 
// Returns:   void
// Parameter: int pv
// Comments:  none
//************************************
void ParticleGenerator::setPopulationVariance( int pv )
{
	populationVariance = pv;
}

//************************************
// Method:    setCentrePoint
// FullName:  ParticleGenerator::setCentrePoint
// Access:    public 
// Returns:   void
// Parameter: BWAPI::Position p
// Comments:  none
//************************************
void ParticleGenerator::setCentrePoint( BWAPI::Position p )
{
	centrePoint = p;
}

std::vector<BWAPI::Position> ParticleGenerator::generateEmpty()
{
	std::vector<BWAPI::Position> population;
	for(int i = 0; i < populationSize; i++) {
		int newX = (rand()%populationVariance);
		int newY = (rand()%populationVariance);
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		BWAPI::Position newPos = BWAPI::Position(centrePoint.x()+newX, centrePoint.y()+newY);
		if(Broodwar->isWalkable(newX/8, newY/8) && newPos.isValid() && Broodwar->getUnitsInRadius(newPos, 16).empty()) {
			population.push_back(newPos);
		} else {
			i--;
		}
	}
	return population;
}

std::vector<BWAPI::Position> ParticleGenerator::generateEmptyClampRegion( BWTA::Region* r )
{
	std::vector<BWAPI::Position> population;
	for(int i = 0; i < populationSize; i++) {
		int newX = (rand()%populationVariance);
		int newY = (rand()%populationVariance);
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		BWAPI::Position newPos = BWAPI::Position(centrePoint.x()+newX, centrePoint.y()+newY);
		if(BWTA::getRegion(newPos) == r && Broodwar->isWalkable(newX/8, newY/8) && newPos.isValid() && Broodwar->getUnitsInRadius(newPos, 16).empty()) {
			population.push_back(newPos);
		} else {
			i--;
		}
	}
	return population;
}
